/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.utils.InputReader;

public class PasswordUpdater {
    private static final String USAGE_MSG_INDENT_SPACES = "         ";
    public static final String DB_URL = "--db-url";
    public static final String DB_DRIVER = "--db-driver";
    public static final String DB_USERNAME = "--db-username";
    public static final String DB_PASSWORD = "--db-password";
    public static final String USERNAME = "--username";
    public static final String NEW_PASSWORD = "--new-password";

    public static void main(String[] args) {
        new PasswordUpdater().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] args) {
        String dbPassword;
        String dbUsername;
        String dbDriver;
        String dbURL;
        String wso2wsasHome = System.getProperty("carbon.home");
        if (wso2wsasHome == null) {
            wso2wsasHome = new File(".").getAbsolutePath();
            System.setProperty("carbon.home", wso2wsasHome);
        }
        if (args.length == 0) {
            this.printUsage();
            System.exit(0);
        }
        if ((dbURL = this.getParam(DB_URL, args)) == null || dbURL.indexOf("jdbc:") != 0) {
            System.err.println(" Invalid database DB_URL : " + dbURL);
            this.printUsage();
            System.exit(0);
        }
        if ((dbDriver = this.getParam(DB_DRIVER, args)) == null) {
            dbDriver = "org.h2.Driver";
        }
        if ((dbUsername = this.getParam(DB_USERNAME, args)) == null) {
            dbUsername = "wso2carbon";
        }
        if ((dbPassword = this.getParam(DB_PASSWORD, args)) == null) {
            dbPassword = "wso2carbon";
        }
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            System.err.println(" Database driver [" + dbDriver + "] not found in classpath.");
            System.exit(1);
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(dbURL, dbUsername, dbPassword);
        }
        catch (Exception e) {
            System.err.println("Cannot connect to database. \nPlease make sure that the JDBC URL is correct and that you have \nstopped WSO2 Carbon before running this script. Root cause is : \n" + e);
            System.exit(1);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        String username = this.getParam(USERNAME, args);
        while (username == null || username.trim().length() == 0) {
            System.out.print("Username: ");
            try {
                username = InputReader.readInput();
            }
            catch (IOException e) {
                System.err.println(" Could not read username : " + e);
                System.exit(1);
            }
        }
        String password = this.getParam(NEW_PASSWORD, args);
        if (password == null || password.trim().length() == 0) {
            String passwordRepeat = null;
            while (password == null || password.trim().length() == 0) {
                try {
                    password = InputReader.readPassword((String)"New password: ");
                }
                catch (IOException e) {
                    System.err.println("Unable to read password : " + e);
                    System.exit(1);
                }
            }
            while (passwordRepeat == null || passwordRepeat.trim().length() == 0) {
                try {
                    passwordRepeat = InputReader.readPassword((String)"Re-enter new password: ");
                }
                catch (IOException e) {
                    System.err.println("Unable to read re-entered password : " + e);
                    System.exit(1);
                }
            }
            if (!password.equals(passwordRepeat)) {
                System.err.println(" Password and re-entered password do not match");
                System.exit(1);
            }
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(dbURL);
        ds.setDriverClassName(dbDriver);
        ds.setUsername(dbUsername);
        ds.setPassword(dbPassword);
        try {
            RealmConfiguration realmConfig = new RealmConfigXMLProcessor().buildRealmConfigurationFromFile();
            JDBCUserStoreManager userStore = new JDBCUserStoreManager((DataSource)ds, realmConfig);
            userStore.doUpdateCredentialByAdmin(username, (Object)password);
            System.out.println("Password updated successfully.");
        }
        catch (UserStoreException ex) {
            System.err.println("Error updating credentials for user " + username + " : " + (Object)((Object)ex));
        }
    }

    private String getParam(String param, String[] args) {
        if (param == null || "".equals(param)) {
            return null;
        }
        for (int i = 0; i < args.length; i += 2) {
            String arg = args[i];
            if (!param.equalsIgnoreCase(arg) || args.length < i + 1) continue;
            return args[i + 1];
        }
        return null;
    }

    private void printUsage() {
        System.out.println("Usage: chpasswd --db-url DB_URL [OPTIONS]\n");
        System.out.println("         --db-url : The JDBC database URL. e.g. jdbc:h2:/home/carbon/database/WSO2CARBON_DB\n");
        System.out.println("Options");
        System.out.println("         --db-driver    : The database driver class. e.g. org.h2.Driver");
        System.out.println("         --db-username  : The database username");
        System.out.println("         --db-password  : The database password");
        System.out.println("         --username     : The username of the user whose password is to be changed. If this is not given, you will be prompted for this field later.");
        System.out.println("         --new-password : The new password of the user whose password is to be changed. If this is not given, you will be prompted for this field later.");
    }
}

