/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.core.monitor;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.status.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorID {
    private static final Logger logger = LoggerFactory.getLogger(MonitorID.class);
    private String userName;
    private Timestamp jobStartedTime;
    private Timestamp lastMonitored;
    private ComputeResourceDescription computeResourceDescription;
    private Map<String, Object> parameters;
    private String experimentID;
    private String workflowNodeID;
    private String taskID;
    private String jobID;
    private String jobName;
    private int failedCount = 0;
    private JobState state;
    private ProcessContext processContext;

    public MonitorID() {
    }

    public MonitorID(MonitorID monitorID) {
        this.computeResourceDescription = monitorID.getComputeResourceDescription();
        this.jobStartedTime = new Timestamp(new Date().getTime());
        this.userName = monitorID.getUserName();
        this.jobID = monitorID.getJobID();
        this.taskID = monitorID.getTaskID();
        this.experimentID = monitorID.getExperimentID();
        this.workflowNodeID = monitorID.getWorkflowNodeID();
        this.jobName = monitorID.getJobName();
    }

    public MonitorID(ComputeResourceDescription computeResourceDescription, String jobID, String taskID, String workflowNodeID, String experimentID, String userName, String jobName) {
        this.computeResourceDescription = computeResourceDescription;
        this.jobStartedTime = new Timestamp(new Date().getTime());
        this.userName = userName;
        this.jobID = jobID;
        this.taskID = taskID;
        this.experimentID = experimentID;
        this.workflowNodeID = workflowNodeID;
        this.jobName = jobName;
    }

    public MonitorID(ProcessContext processContext) {
    }

    public ComputeResourceDescription getComputeResourceDescription() {
        return this.computeResourceDescription;
    }

    public void setComputeResourceDescription(ComputeResourceDescription computeResourceDescription) {
        this.computeResourceDescription = computeResourceDescription;
    }

    public Timestamp getLastMonitored() {
        return this.lastMonitored;
    }

    public void setLastMonitored(Timestamp lastMonitored) {
        this.lastMonitored = lastMonitored;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String jobID) {
        this.jobID = jobID;
    }

    public Timestamp getJobStartedTime() {
        return this.jobStartedTime;
    }

    public void setJobStartedTime(Timestamp jobStartedTime) {
        this.jobStartedTime = jobStartedTime;
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getExperimentID() {
        return this.experimentID;
    }

    public void setExperimentID(String experimentID) {
        this.experimentID = experimentID;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String taskID) {
        this.taskID = taskID;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public void setFailedCount(int failedCount) {
        this.failedCount = failedCount;
    }

    public JobState getStatus() {
        return this.state;
    }

    public void setStatus(JobState status) {
        if (this.state != null && status.equals((Object)JobState.UNKNOWN)) {
            ++this.failedCount;
            logger.info(this.getJobID(), new Object[]{"{} status came for job {}, Increasing the failed count to: {}.", status.toString(), this.jobID, this.failedCount});
        } else {
            logger.info(this.getJobID(), new Object[]{"Valid status {} came for job {}, resetting fail count to 0", status.toString(), this.jobID});
            this.setFailedCount(0);
            this.state = status;
        }
    }

    public String getWorkflowNodeID() {
        return this.workflowNodeID;
    }

    public void setWorkflowNodeID(String workflowNodeID) {
        this.workflowNodeID = workflowNodeID;
    }

    public ProcessContext getProcessContext() {
        return this.processContext;
    }

    public void setProcessContext(ProcessContext processContext) {
        this.processContext = processContext;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }
}

