/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.delegation.server.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class PAResponseImpl
implements PAResponse {
    Map<String, String> parameters;
    Map<String, String> additionalInformation;
    AccessToken accessToken;
    ProtectedAsset protectedAsset;

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new HashMap<String, String>();
        }
        return this.additionalInformation;
    }

    public void setAdditionalInformation(Map<String, String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public void write(HttpServletResponse response) {
        if (this.protectedAsset == null) {
            throw new GeneralException("Error, no protected asset =");
        }
        if (!(this.getProtectedAsset() instanceof MyX509Certificates)) {
            throw new NotImplementedException("Error, this implementation can only serialize MyX509Certificates and a protected asset of type \"" + this.getProtectedAsset().getClass().getName() + "\" was found instead");
        }
        try {
            MyX509Certificates certs = (MyX509Certificates)this.getProtectedAsset();
            if (certs == null || certs.getX509CertificatesPEM() == null) {
                throw new GeneralException("Error: No certificate found.");
            }
            response.setContentType("application/x-www-form-urlencoded");
            ServletOutputStream out = response.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out);
            for (String key : this.getAdditionalInformation().keySet()) {
                osw.write(key + "=" + this.getAdditionalInformation().get(key) + "\n");
            }
            osw.flush();
            out.write(certs.getX509CertificatesPEM().getBytes());
            out.flush();
            out.close();
        }
        catch (Exception x) {
            throw new GeneralException((Throwable)x);
        }
    }

    public ProtectedAsset getProtectedAsset() {
        return this.protectedAsset;
    }

    public void setProtectedAsset(ProtectedAsset protectedAsset) {
        this.protectedAsset = protectedAsset;
    }
}

