/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.dispatcher;

import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import javax.jws.soap.SOAPBinding;
import org.apache.axis2.AxisFault;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.utils.ContextUtils;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.core.util.MessageContextUtils;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.factory.MethodMarshallerFactory;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointCallback;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.dispatcher.JavaDispatcher;
import org.apache.axis2.jaxws.server.endpoint.Utils;
import org.apache.axis2.jaxws.utility.ExecutorFactory;
import org.apache.axis2.jaxws.utility.SingleThreadedExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaBeanDispatcher
extends JavaDispatcher {
    private static final Log log = LogFactory.getLog(JavaBeanDispatcher.class);
    private EndpointDescription endpointDesc = null;

    public JavaBeanDispatcher(Class implClass, Object serviceInstance) {
        super(implClass, serviceInstance);
    }

    public MessageContext invoke(MessageContext mc) throws Exception {
        Object output;
        Throwable fault;
        boolean faultThrown;
        Method target;
        Object[] methodInputParams;
        OperationDescription operationDesc;
        block9: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking service endpoint: " + this.serviceImplClass.getName()));
                log.debug((Object)"Invocation pattern: two way, sync");
            }
            this.initialize(mc);
            operationDesc = Utils.getOperationDescription(mc);
            methodInputParams = this.createRequestParameters(mc);
            target = this.getJavaMethod(mc, this.serviceImplClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString()));
            }
            faultThrown = false;
            fault = null;
            output = null;
            try {
                output = this.invokeTargetOperation(target, methodInputParams);
            }
            catch (Throwable e) {
                faultThrown = true;
                fault = e;
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)("Caught exception from 'invokeTargetOperation': " + fault.toString()));
            }
        }
        MessageContext response = null;
        if (operationDesc.isOneWay()) {
            return null;
        }
        if (faultThrown) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing fault response: " + fault.toString()));
            }
            response = this.createFaultResponse(mc, mc.getMessage().getProtocol(), fault);
            JavaBeanDispatcher.setExceptionProperties(response, target, fault);
        } else {
            response = this.createResponse(mc, mc.getMessage().getProtocol(), methodInputParams, output);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Returning from JavaBeanDispatcher.invoke()...");
        }
        return response;
    }

    public void invokeOneWay(MessageContext request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking service endpoint: " + this.serviceImplClass.getName()));
            log.debug((Object)"Invocation pattern: one way");
        }
        this.initialize(request);
        OperationDescription operationDesc = Utils.getOperationDescription(request);
        Object[] methodInputParams = this.createRequestParameters(request);
        Method target = this.getJavaMethod(request, this.serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString()));
        }
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = JavaBeanDispatcher.getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(this, target, methodInputParams, cl, eic);
        FutureTask task = new FutureTask(worker);
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        executor.execute(task);
    }

    public void invokeAsync(MessageContext request, EndpointCallback callback) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoking service endpoint: " + this.serviceImplClass.getName()));
            log.debug((Object)"Invocation pattern: two way, async");
        }
        this.initialize(request);
        OperationDescription operationDesc = Utils.getOperationDescription(request);
        Object[] methodInputParams = this.createRequestParameters(request);
        Method target = this.getJavaMethod(request, this.serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)("JavaBeanDispatcher about to invoke using OperationDesc: " + operationDesc.toString()));
        }
        EndpointInvocationContext eic = (EndpointInvocationContext)request.getInvocationContext();
        ClassLoader cl = JavaBeanDispatcher.getContextClassLoader();
        JavaDispatcher.AsyncInvocationWorker worker = new JavaDispatcher.AsyncInvocationWorker(this, target, methodInputParams, cl, eic);
        FutureTask task = new FutureTask(worker);
        ExecutorFactory ef = (ExecutorFactory)FactoryRegistry.getFactory(ExecutorFactory.class);
        Executor executor = ef.getExecutorInstance(1);
        Boolean disable = (Boolean)request.getProperty("serverDisableThreadSwitch");
        if (disable != null && disable.booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Server side thread switch disabled.  Setting Executor to the SingleThreadedExecutor.");
            }
            executor = new SingleThreadedExecutor();
        }
        executor.execute(task);
    }

    protected void initialize(MessageContext mc) {
        mc.setOperationName(mc.getAxisMessageContext().getAxisOperation().getName());
        mc.setOperationDescription(Utils.getOperationDescription(mc));
        this.endpointDesc = mc.getEndpointDescription();
        if (this.endpointDesc.isMTOMEnabled()) {
            mc.getMessage().setMTOMEnabled(true);
        }
        ContextUtils.addWSDLProperties(mc);
    }

    private MethodMarshaller getMethodMarshaller(Protocol protocol, OperationDescription operationDesc, MessageContext mc) {
        SOAPBinding.Style styleOnSEI = this.endpointDesc.getEndpointInterfaceDescription().getSoapBindingStyle();
        SOAPBinding.Style styleOnMethod = operationDesc.getSoapBindingStyle();
        if (styleOnMethod != null && styleOnSEI != styleOnMethod) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyErr2"));
        }
        ClassLoader cl = null;
        if (mc != null) {
            cl = (ClassLoader)mc.getProperty("CACHE_CLASSLOADER");
        }
        return MethodMarshallerFactory.getMarshaller(operationDesc, false, cl);
    }

    protected Method getJavaMethod(MessageContext mc, Class serviceImplClass) {
        OperationDescription opDesc = mc.getOperationDescription();
        if (opDesc == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("proxyErr3"));
        }
        Method returnMethod = opDesc.getMethodFromServiceImpl(serviceImplClass);
        if (returnMethod == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("JavaBeanDispatcherErr1"));
        }
        return returnMethod;
    }

    private Object[] createRequestParameters(MessageContext request) {
        Protocol requestProtocol = request.getMessage().getProtocol();
        MethodMarshaller methodMarshaller = this.getMethodMarshaller(requestProtocol, request.getOperationDescription(), request);
        Object[] methodInputParams = methodMarshaller.demarshalRequest(request.getMessage(), request.getOperationDescription());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshalled parameters for request");
            if (methodInputParams != null) {
                log.debug((Object)(methodInputParams.length + " parameters were found."));
            }
        }
        return methodInputParams;
    }

    public MessageContext createResponse(MessageContext request, Object[] input, Object output) {
        return this.createResponse(request, request.getMessage().getProtocol(), input, output);
    }

    public MessageContext createResponse(MessageContext request, Protocol p, Object[] params, Object output) {
        OperationDescription operationDesc = request.getOperationDescription();
        Method method = operationDesc.getMethodFromServiceImpl(this.serviceImplClass);
        MethodMarshaller marshaller = this.getMethodMarshaller(p, request.getOperationDescription(), request);
        Message m = null;
        m = method.getReturnType().getName().equals("void") ? marshaller.marshalResponse(null, params, operationDesc, p) : marshaller.marshalResponse(output, params, operationDesc, p);
        MessageContext response = MessageContextUtils.createResponseMessageContext(request);
        response.setMessage(m);
        EndpointDescription epDesc = request.getEndpointDescription();
        String bindingType = epDesc.getBindingType();
        boolean isMTOMBinding = epDesc.isMTOMEnabled();
        boolean isDoingSWA = m.isDoingSWA();
        if (log.isDebugEnabled()) {
            log.debug((Object)("EndpointDescription = " + epDesc.toString()));
            log.debug((Object)("BindingType = " + bindingType));
            log.debug((Object)("isMTOMBinding = " + isMTOMBinding));
            log.debug((Object)("isDoingSWA = " + isDoingSWA));
        }
        if (!m.isDoingSWA() && isMTOMBinding) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"MTOM enabled for the response message.");
            }
            m.setMTOMEnabled(true);
        }
        return response;
    }

    public MessageContext createFaultResponse(MessageContext request, Throwable t) {
        return this.createFaultResponse(request, request.getMessage().getProtocol(), t);
    }

    public MessageContext createFaultResponse(MessageContext request, Protocol p, Throwable t) {
        Throwable faultMessage;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Entered JavaBeanDispatcher.createFaultResponse()...");
        }
        if ((faultMessage = InvocationHelper.determineMappedException(t, request)) != null) {
            t = faultMessage;
        }
        MethodMarshaller marshaller = this.getMethodMarshaller(p, request.getOperationDescription(), request);
        Message m = marshaller.marshalFaultResponse(t, request.getOperationDescription(), p);
        MessageContext response = MessageContextUtils.createFaultMessageContext(request);
        response.setMessage(m);
        AxisFault axisFault = new AxisFault("The endpoint returned a fault when invoking the target operation.", response.getAxisMessageContext(), t);
        response.setCausedByException(axisFault);
        JavaBeanDispatcher.setFaultResponseAction(t, request, response);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Leaving JavaBeanDispatcher.createFaultResponse()...");
        }
        return response;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception wrappedE;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            if ((wrappedE = e.getException()) instanceof RuntimeException) {
                throw (RuntimeException)wrappedE;
            }
            throw new RuntimeException(wrappedE);
        }
        return cl;
    }
}

