/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.RejectedExecutionException;
import org.apache.axis2.transport.http.server.AxisHttpConnectionImpl;
import org.apache.axis2.transport.http.server.ConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class DefaultConnectionListener
implements IOProcessor {
    private static Log LOG = LogFactory.getLog(DefaultConnectionListener.class);
    private volatile boolean destroyed = false;
    private final int port;
    private final HttpConnectionManager connmanager;
    private final ConnectionListenerFailureHandler failureHandler;
    private final HttpParams params;
    private ServerSocket serversocket = null;

    public DefaultConnectionListener(int port, HttpConnectionManager connmanager, ConnectionListenerFailureHandler failureHandler, HttpParams params) throws IOException {
        if (connmanager == null) {
            throw new IllegalArgumentException("Connection manager may not be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("Failure handler may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.port = port;
        this.connmanager = connmanager;
        this.failureHandler = failureHandler;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block15: {
            block8: while (true) {
                while (!Thread.interrupted()) {
                    try {
                        if (this.serversocket == null || this.serversocket.isClosed()) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)("Listening on port " + this.port));
                            }
                            this.serversocket = new ServerSocket(this.port);
                            this.serversocket.setReuseAddress(true);
                        }
                        LOG.debug((Object)"Waiting for incoming HTTP connection");
                        Socket socket = this.serversocket.accept();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Incoming HTTP connection from " + socket.getRemoteSocketAddress()));
                        }
                        AxisHttpConnectionImpl conn = new AxisHttpConnectionImpl(socket, this.params);
                        try {
                            this.connmanager.process(conn);
                            continue block8;
                        }
                        catch (RejectedExecutionException e) {
                            conn.sendResponse(new DefaultHttpResponseFactory().newHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_0, 503, (HttpContext)new BasicHttpContext(null)));
                        }
                    }
                    catch (InterruptedIOException ie) {
                        break block15;
                    }
                    catch (Throwable ex) {
                        if (Thread.interrupted()) {
                        } else if (this.failureHandler.failed(this, ex)) continue;
                        break block15;
                    }
                }
                break block15;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                this.destroy();
            }
        }
    }

    public void close() throws IOException {
        if (this.serversocket != null) {
            this.serversocket.close();
        }
    }

    public void destroy() {
        block2: {
            this.destroyed = true;
            try {
                this.close();
            }
            catch (IOException ex) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.warn((Object)"I/O error closing listener", (Throwable)ex);
            }
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }
}

