/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericFileName;

public class URLFileName
extends GenericFileName {
    private static final int BUFFER_SIZE = 250;
    private final String queryString;

    public URLFileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type);
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQuery() {
        StringBuilder sb = new StringBuilder(250);
        sb.append(this.getPath());
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }

    public String getPathQueryEncoded(String charset) throws URIException, FileSystemException {
        if (this.getQueryString() == null) {
            if (charset != null) {
                return URIUtil.encodePath((String)this.getPathDecoded(), (String)charset);
            }
            return URIUtil.encodePath((String)this.getPathDecoded());
        }
        StringBuilder sb = new StringBuilder(250);
        if (charset != null) {
            sb.append(URIUtil.encodePath((String)this.getPathDecoded(), (String)charset));
        } else {
            sb.append(URIUtil.encodePath((String)this.getPathDecoded()));
        }
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }

    @Override
    public FileName createName(String absPath, FileType type) {
        return new URLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), absPath, type, this.getQueryString());
    }

    @Override
    protected String createURI() {
        if (this.getQueryString() != null) {
            StringBuilder sb = new StringBuilder(250);
            sb.append(super.createURI());
            sb.append("?");
            sb.append(this.getQueryString());
            return sb.toString();
        }
        return super.createURI();
    }

    public String getURIEncoded(String charset) throws FileSystemException, URIException {
        StringBuilder sb = new StringBuilder(250);
        this.appendRootUri(sb, true);
        sb.append(this.getPathQueryEncoded(charset));
        return sb.toString();
    }
}

