/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.obr.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.obr.internal.FelixCapabilityAdapter;
import org.apache.aries.subsystem.obr.internal.FelixRepositoryAdapter;
import org.apache.aries.subsystem.obr.internal.FelixResourceAdapter;
import org.apache.aries.subsystem.obr.internal.OsgiRequirementAdapter;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.osgi.resource.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryAdminRepository
implements org.osgi.service.repository.Repository {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryAdminRepository.class);
    private final RepositoryAdmin repositoryAdmin;

    public RepositoryAdminRepository(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public Collection<org.osgi.resource.Capability> findProviders(Requirement requirement) {
        logger.debug("Method entry: {}, args {}", (Object)"findProviders", (Object)requirement);
        List<org.osgi.resource.Capability> result = Collections.emptyList();
        if ("osgi.identity".equals(requirement.getNamespace())) {
            result = new ArrayList();
            for (Repository r : this.repositoryAdmin.listRepositories()) {
                FelixRepositoryAdapter repository = new FelixRepositoryAdapter(r);
                Map<Requirement, Collection<org.osgi.resource.Capability>> map = repository.findProviders(Arrays.asList(requirement));
                Collection<org.osgi.resource.Capability> capabilities = map.get(requirement);
                if (capabilities == null) continue;
                result.addAll(capabilities);
            }
            return result;
        }
        Resource[] resources = this.repositoryAdmin.discoverResources(new org.apache.felix.bundlerepository.Requirement[]{new OsgiRequirementAdapter(requirement)});
        logger.debug("Found {} resources with capabilities satisfying {}", (Object)(resources == null ? 0 : resources.length), (Object)requirement);
        if (resources != null && resources.length != 0) {
            result = new ArrayList<org.osgi.resource.Capability>(result.size());
            OsgiRequirementAdapter adapter = new OsgiRequirementAdapter(requirement);
            for (Resource resource : resources) {
                logger.debug("Evaluating resource {}", (Object)resource);
                for (Capability capability : resource.getCapabilities()) {
                    logger.debug("Evaluating capability {}", (Object)capability);
                    if (!adapter.isSatisfied(capability)) continue;
                    logger.debug("Adding capability {}", (Object)capability);
                    result.add(new FelixCapabilityAdapter(capability, new FelixResourceAdapter(resource)));
                }
            }
        }
        logger.debug("Method exit: {}, returning {}", (Object)"findProviders", result);
        return result;
    }

    public Map<Requirement, Collection<org.osgi.resource.Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<org.osgi.resource.Capability>> result = new HashMap<Requirement, Collection<org.osgi.resource.Capability>>(requirements.size());
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }
}

