/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.LongPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.freepage.MutableArrayValueReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMIOOperationCallback
implements ILSMIOOperationCallback {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String KEY_FLUSH_LOG_LSN = "FlushLogLsn";
    public static final String KEY_NEXT_COMPONENT_ID = "NextComponentId";
    public static final String KEY_FLUSHED_COMPONENT_ID = "FlushedComponentId";
    private static final String KEY_FIRST_LSN = "FirstLsn";
    private static final MutableArrayValueReference KEY_METADATA_FLUSH_LOG_LSN = new MutableArrayValueReference("FlushLogLsn".getBytes());
    public static final long INVALID_LSN = -1L;
    private final ArrayBackedValueStorage buffer = new ArrayBackedValueStorage(8);
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;
    protected final DatasetInfo dsInfo;
    protected final ILSMIndex lsmIndex;
    private long firstLsnForCurrentMemoryComponent = 0L;
    private long persistenceLsn = 0L;
    private int pendingFlushes = 0;
    private Deque<ILSMComponentId> componentIds = new ArrayDeque<ILSMComponentId>();

    public LSMIOOperationCallback(DatasetInfo dsInfo, ILSMIndex lsmIndex, ILSMComponentId componentId, IIndexCheckpointManagerProvider indexCheckpointManagerProvider) {
        this.dsInfo = dsInfo;
        this.lsmIndex = lsmIndex;
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
        this.componentIds.add(componentId);
    }

    public void beforeOperation(ILSMIOOperation operation) throws HyracksDataException {
        if (this.isMerge(operation)) {
            FileReference operationMaskFilePath = LSMIOOperationCallback.getOperationMaskFilePath(operation);
            if (!operationMaskFilePath.getFile().exists()) {
                IoUtil.create((FileReference)operationMaskFilePath);
            } else {
                LOGGER.warn("merge operation mask file {} already exists", (Object)operationMaskFilePath);
            }
        }
    }

    public void afterOperation(ILSMIOOperation operation) throws HyracksDataException {
        if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            return;
        }
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.LOAD) {
            Map map = operation.getParameters();
            this.putComponentIdIntoMetadata(operation.getNewComponent(), (ILSMComponentId)((LSMComponentId)map.get(KEY_FLUSHED_COMPONENT_ID)));
        } else if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            Map map = operation.getParameters();
            this.putLSNIntoMetadata(operation.getNewComponent(), (Long)map.get(KEY_FLUSH_LOG_LSN));
            this.putComponentIdIntoMetadata(operation.getNewComponent(), ((FlushOperation)operation).getFlushingComponent().getId());
        } else if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE) {
            List mergedComponents = operation.getAccessor().getOpContext().getComponentsToBeMerged();
            this.putLSNIntoMetadata(operation.getNewComponent(), mergedComponents);
            this.putComponentIdIntoMetadata(operation.getNewComponent(), mergedComponents);
            LongPointable markerLsn = LongPointable.FACTORY.createPointable(ComponentUtils.getLong((IComponentMetadata)((ILSMDiskComponent)mergedComponents.get(0)).getMetadata(), (IValueReference)ComponentUtils.MARKER_LSN_KEY, (long)-1L, (ArrayBackedValueStorage)this.buffer));
            operation.getNewComponent().getMetadata().put((IValueReference)ComponentUtils.MARKER_LSN_KEY, (IValueReference)markerLsn);
        }
    }

    public void afterFinalize(ILSMIOOperation operation) throws HyracksDataException {
        if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.FAILURE) {
            return;
        }
        if (operation.getIOOpertionType() != ILSMIOOperation.LSMIOOperationType.LOAD && operation.getAccessor().getOpContext().getOperation() == IndexOperation.DELETE_COMPONENTS) {
            this.deleteComponentsFromCheckpoint(operation);
        } else if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH || operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.LOAD) {
            this.addComponentToCheckpoint(operation);
        } else if (this.isMerge(operation)) {
            IoUtil.delete((FileReference)LSMIOOperationCallback.getOperationMaskFilePath(operation));
        }
    }

    private void addComponentToCheckpoint(ILSMIOOperation operation) throws HyracksDataException {
        FileReference target = operation.getTarget();
        Map map = operation.getParameters();
        Long lsn = operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH ? (Long)map.get(KEY_FLUSH_LOG_LSN) : 0L;
        LSMComponentId id = (LSMComponentId)map.get(KEY_FLUSHED_COMPONENT_ID);
        ResourceReference ref = ResourceReference.of(target.getAbsolutePath());
        long componentSequence = IndexComponentFileReference.of((String)ref.getName()).getSequenceEnd();
        this.indexCheckpointManagerProvider.get(ref).flushed(componentSequence, lsn, id.getMaxId());
    }

    private void deleteComponentsFromCheckpoint(ILSMIOOperation operation) throws HyracksDataException {
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE) {
            LSMComponentId mostRecentComponentId = this.getMostRecentComponentId(operation.getAccessor().getOpContext().getComponentsToBeMerged());
            FileReference target = operation.getTarget();
            ResourceReference ref = ResourceReference.of(target.getAbsolutePath());
            this.indexCheckpointManagerProvider.get(ref).setLastComponentId(mostRecentComponentId.getMaxId());
        } else if (operation.getIOOpertionType() != ILSMIOOperation.LSMIOOperationType.FLUSH) {
            throw new IllegalStateException("Unexpected IO operation: " + operation.getIOOpertionType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LSMComponentId getMostRecentComponentId(Collection<ILSMDiskComponent> deletedComponents) throws HyracksDataException {
        ILSMOperationTracker iLSMOperationTracker = this.lsmIndex.getOperationTracker();
        synchronized (iLSMOperationTracker) {
            List diskComponents = this.lsmIndex.getDiskComponents();
            if (diskComponents.isEmpty()) {
                LOGGER.log(Level.INFO, "There are no disk components");
                return LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID;
            }
            if (deletedComponents.contains(diskComponents.get(diskComponents.size() - 1))) {
                LOGGER.log(Level.INFO, "All disk components have been deleted");
                return LSMComponentId.EMPTY_INDEX_LAST_COMPONENT_ID;
            }
            int mostRecentComponentIndex = 0;
            for (int i = 0; i < diskComponents.size() && deletedComponents.contains(diskComponents.get(i)); ++i) {
                ++mostRecentComponentIndex;
            }
            ILSMDiskComponent mostRecentDiskComponent = (ILSMDiskComponent)diskComponents.get(mostRecentComponentIndex);
            return (LSMComponentId)mostRecentDiskComponent.getId();
        }
    }

    private void putLSNIntoMetadata(ILSMDiskComponent newComponent, List<ILSMDiskComponent> oldComponents) throws HyracksDataException {
        this.putLSNIntoMetadata(newComponent, this.getComponentLSN(oldComponents));
    }

    private void putLSNIntoMetadata(ILSMDiskComponent newComponent, long lsn) throws HyracksDataException {
        newComponent.getMetadata().put((IValueReference)KEY_METADATA_FLUSH_LOG_LSN, (IValueReference)LongPointable.FACTORY.createPointable(lsn));
    }

    public static long getTreeIndexLSN(DiskComponentMetadata md) throws HyracksDataException {
        LongPointable pointable = new LongPointable();
        IMetadataPageManager metadataPageManager = md.getMetadataPageManager();
        metadataPageManager.get(metadataPageManager.createMetadataFrame(), (IValueReference)KEY_METADATA_FLUSH_LOG_LSN, (IPointable)pointable);
        return pointable.getLength() == 0 ? -1L : pointable.longValue();
    }

    private ILSMComponentId getMergedComponentId(List<? extends ILSMComponent> mergedComponents) throws HyracksDataException {
        if (mergedComponents.isEmpty()) {
            return null;
        }
        return LSMComponentIdUtils.union((ILSMComponentId)mergedComponents.get(0).getId(), (ILSMComponentId)mergedComponents.get(mergedComponents.size() - 1).getId());
    }

    private void putComponentIdIntoMetadata(ILSMDiskComponent newComponent, List<ILSMDiskComponent> oldComponents) throws HyracksDataException {
        ILSMComponentId componentId = this.getMergedComponentId(oldComponents);
        this.putComponentIdIntoMetadata(newComponent, componentId);
    }

    private void putComponentIdIntoMetadata(ILSMDiskComponent newComponent, ILSMComponentId componentId) throws HyracksDataException {
        LSMComponentIdUtils.persist((ILSMComponentId)componentId, (IComponentMetadata)newComponent.getMetadata());
    }

    public synchronized void setFirstLsnForCurrentMemoryComponent(long firstLsn) {
        this.firstLsnForCurrentMemoryComponent = firstLsn;
        if (this.pendingFlushes == 0) {
            this.persistenceLsn = firstLsn;
        }
    }

    public synchronized long getPersistenceLsn() {
        return this.persistenceLsn;
    }

    public long getComponentLSN(List<ILSMDiskComponent> diskComponents) throws HyracksDataException {
        if (diskComponents.isEmpty()) {
            throw new IllegalArgumentException("Can't get LSN from an empty list of disk components");
        }
        long maxLSN = -1L;
        for (ILSMDiskComponent c : diskComponents) {
            DiskComponentMetadata md = c.getMetadata();
            maxLSN = Math.max(LSMIOOperationCallback.getTreeIndexLSN(md), maxLSN);
        }
        return maxLSN;
    }

    public void recycled(ILSMMemoryComponent component) throws HyracksDataException {
        component.resetId(this.componentIds.poll(), false);
    }

    public synchronized void scheduled(ILSMIOOperation operation) throws HyracksDataException {
        this.dsInfo.declareActiveIOOperation(operation.getIOOpertionType());
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            ++this.pendingFlushes;
            FlushOperation flush = (FlushOperation)operation;
            Map map = operation.getAccessor().getOpContext().getParameters();
            Long flushLsn = (Long)map.get(KEY_FLUSH_LOG_LSN);
            map.put(KEY_FIRST_LSN, this.firstLsnForCurrentMemoryComponent);
            map.put(KEY_FLUSHED_COMPONENT_ID, flush.getFlushingComponent().getId());
            this.componentIds.add((ILSMComponentId)map.get(KEY_NEXT_COMPONENT_ID));
            this.firstLsnForCurrentMemoryComponent = flushLsn;
        }
    }

    public synchronized void completed(ILSMIOOperation operation) {
        if (operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.FLUSH) {
            --this.pendingFlushes;
            if (operation.getStatus() == ILSMIOOperation.LSMIOOperationStatus.SUCCESS) {
                Map map = operation.getAccessor().getOpContext().getParameters();
                this.persistenceLsn = this.pendingFlushes == 0 ? this.firstLsnForCurrentMemoryComponent : (Long)map.get(KEY_FLUSH_LOG_LSN);
            }
        }
        this.dsInfo.undeclareActiveIOOperation(operation.getIOOpertionType());
    }

    public synchronized boolean hasPendingFlush() {
        return this.pendingFlushes > 0;
    }

    public void allocated(ILSMMemoryComponent component) throws HyracksDataException {
    }

    private boolean isMerge(ILSMIOOperation operation) {
        return operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE && operation.getAccessor().getOpContext().getOperation() != IndexOperation.DELETE_COMPONENTS;
    }

    private static FileReference getOperationMaskFilePath(ILSMIOOperation operation) {
        FileReference target = operation.getTarget();
        String componentSequence = ResourceReference.getComponentSequence(target.getFile().getAbsolutePath());
        Path idxRelPath = Paths.get(target.getRelativePath(), new String[0]).getParent();
        Path maskFileRelPath = Paths.get(idxRelPath.toString(), ".mask_C_" + componentSequence);
        return new FileReference(target.getDeviceHandle(), maskFileRelPath.toString());
    }
}

