/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import org.apache.asterix.common.external.IDataSourceAdapter;
import org.apache.asterix.external.api.ITypedAdapterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;

public class ExternalScanOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private ITypedAdapterFactory adapterFactory;

    public ExternalScanOperatorDescriptor(JobSpecification spec, RecordDescriptor rDesc, ITypedAdapterFactory dataSourceAdapterFactory) {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        this.outRecDescs[0] = rDesc;
        this.adapterFactory = dataSourceAdapterFactory;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        return new AbstractUnaryOutputSourceOperatorNodePushable(){
            private IOperatorStats stats;

            public void initialize() throws HyracksDataException {
                if (ctx.getStatsCollector() != null) {
                    this.stats = ctx.getStatsCollector().getOrAddOperatorStats(this.getDisplayName());
                }
                try {
                    this.writer.open();
                    IDataSourceAdapter adapter = ExternalScanOperatorDescriptor.this.adapterFactory.createAdapter(ctx, partition);
                    adapter.start(partition, this.writer);
                    if (this.stats != null) {
                        this.stats.getTupleCounter().update(adapter.getProcessedTuples());
                    }
                }
                catch (Exception e) {
                    this.writer.fail();
                    throw HyracksDataException.create((Throwable)e);
                }
                finally {
                    this.writer.close();
                }
            }
        };
    }
}

