/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common;

import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerShutdownHook
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IControllerService controllerService;

    public ControllerShutdownHook(IServiceContext serviceCtx) {
        super("ShutdownHook-" + serviceCtx.getControllerService().getId());
        this.controllerService = serviceCtx.getControllerService();
    }

    @Override
    public void run() {
        try {
            try {
                LOGGER.info("Shutdown hook called");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            LOGGER.log(Level.DEBUG, () -> "Thread dump at shutdown: " + ThreadDumpUtil.takeDumpString());
            this.controllerService.stop();
        }
        catch (Throwable th) {
            LOGGER.log(Level.WARN, "Exception in executing shutdown hook", th);
        }
    }
}

