/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.teradata.tpcds.distribution.StringValuesDistribution;
import com.teradata.tpcds.random.RandomNumberStream;

public final class AddressDistributions {
    private static final StringValuesDistribution STREET_NAMES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("street_names.dst", 1, 2);
    private static final StringValuesDistribution STREET_TYPES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("street_types.dst", 1, 1);
    private static final StringValuesDistribution CITIES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("cities.dst", 1, 6);
    private static final StringValuesDistribution COUNTRIES_DISTRIBUTION = StringValuesDistribution.buildStringValuesDistribution("countries.dst", 1, 1);

    private AddressDistributions() {
    }

    public static String pickRandomStreetName(StreetNamesWeights streetNamesWeights, RandomNumberStream stream) {
        return STREET_NAMES_DISTRIBUTION.pickRandomValue(0, streetNamesWeights.ordinal(), stream);
    }

    public static String pickRandomStreetType(RandomNumberStream stream) {
        return STREET_TYPES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String pickRandomCity(CitiesWeights citiesWeights, RandomNumberStream stream) {
        return CITIES_DISTRIBUTION.pickRandomValue(0, citiesWeights.ordinal(), stream);
    }

    public static String pickRandomCountry(RandomNumberStream stream) {
        return COUNTRIES_DISTRIBUTION.pickRandomValue(0, 0, stream);
    }

    public static String getCityAtIndex(int index) {
        return CITIES_DISTRIBUTION.getValueAtIndex(0, index);
    }

    public static enum CitiesWeights {
        USGS_SKEWED,
        UNIFORM,
        LARGE,
        MEDIUM,
        SMALL,
        UNIFIED_STEP_FUNCTION;

    }

    public static enum StreetNamesWeights {
        DEFAULT,
        HALF_EMPTY;

    }
}

