/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.utils;

public class SingleVarFunctionsUtil {
    private double m1 = 0.0;
    private double m2 = 0.0;
    private double m3;
    private double m4;
    private long count = 0L;
    private boolean m3Flag;
    private boolean m4Flag;

    public void set(double moment1, double moment2, double moment3, double moment4, long cnt, boolean moment3Flag, boolean moment4Flag) {
        this.m1 = moment1;
        this.m2 = moment2;
        this.m3 = moment3;
        this.m4 = moment4;
        this.count = cnt;
        this.m3Flag = moment3Flag;
        this.m4Flag = moment4Flag;
    }

    public void push(double val) {
        ++this.count;
        double delta = val - this.m1;
        double delta_n = delta / (double)this.count;
        double term1 = delta * delta_n * (double)(this.count - 1L);
        this.m1 += delta / (double)this.count;
        if (this.m4Flag) {
            this.m4 += term1 * delta_n * delta_n * (double)(this.count * this.count - 3L * this.count + 3L);
            this.m4 += 6.0 * delta_n * delta_n * this.m2 - 4.0 * delta_n * this.m3;
        }
        if (this.m3Flag) {
            this.m3 += term1 * delta_n * (double)(this.count - 2L) - 3.0 * delta_n * this.m2;
        }
        this.m2 += term1;
    }

    public void combine(double moment1, double moment2, double moment3, double moment4, long cnt) {
        double delta = moment1 - this.m1;
        long combined_count = this.count + cnt;
        if (this.m3Flag) {
            double delta3 = delta * delta * delta;
            if (this.m4Flag) {
                this.m4 += moment4 + delta3 * delta * (double)this.count * (double)cnt * (double)(this.count * this.count - this.count * cnt + cnt * cnt) / (double)(combined_count * combined_count * combined_count);
                this.m4 += 6.0 * delta * delta * ((double)(this.count * this.count) * moment2 + (double)(cnt * cnt) * this.m2) / (double)(combined_count * combined_count) + 4.0 * delta * ((double)this.count * moment3 - (double)cnt * this.m3) / (double)combined_count;
            }
            this.m3 += moment3 + delta3 * (double)this.count * (double)cnt * (double)(this.count - cnt) / (double)(combined_count * combined_count);
            this.m3 += 3.0 * delta * ((double)this.count * moment2 - (double)cnt * this.m2) / (double)combined_count;
        }
        this.m1 = ((double)this.count * this.m1 + (double)cnt * moment1) / (double)combined_count;
        this.m2 += moment2 + delta * delta * (double)this.count * (double)cnt / (double)combined_count;
        this.count = combined_count;
    }

    public double getM1() {
        return this.m1;
    }

    public double getM2() {
        return this.m2;
    }

    public double getM3() {
        return this.m3;
    }

    public double getM4() {
        return this.m4;
    }

    public long getCount() {
        return this.count;
    }
}

