/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.io;

import software.amazon.awssdk.crt.CrtResource;

public final class SocketOptions
extends CrtResource {
    public SocketDomain domain = SocketDomain.IPv6;
    public SocketType type = SocketType.STREAM;
    public int connectTimeoutMs = 3000;
    public int keepAliveIntervalSecs = 0;
    public int keepAliveTimeoutSecs = 0;
    public boolean keepAlive = false;

    @Override
    public long getNativeHandle() {
        if (super.getNativeHandle() == 0L) {
            this.acquireNativeHandle(SocketOptions.socketOptionsNew(this.domain.getValue(), this.type.getValue(), this.connectTimeoutMs, this.keepAliveIntervalSecs, this.keepAliveTimeoutSecs, this.keepAlive));
        }
        return super.getNativeHandle();
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return true;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            SocketOptions.socketOptionsDestroy(this.getNativeHandle());
        }
    }

    private static native long socketOptionsNew(int var0, int var1, int var2, int var3, int var4, boolean var5);

    private static native void socketOptionsDestroy(long var0);

    public static enum SocketType {
        STREAM(0),
        DGRAM(1);

        private int type;

        private SocketType(int val) {
            this.type = val;
        }

        int getValue() {
            return this.type;
        }
    }

    public static enum SocketDomain {
        IPv4(0),
        IPv6(1),
        LOCAL(2);

        private int domain;

        private SocketDomain(int val) {
            this.domain = val;
        }

        int getValue() {
            return this.domain;
        }
    }
}

