/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IAsterixStateProxy;
import org.apache.asterix.metadata.api.IExtensionMetadataEntity;
import org.apache.asterix.metadata.api.IExtensionMetadataSearchKey;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.api.IMetadataManager;
import org.apache.asterix.metadata.api.IMetadataNode;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Database;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.Node;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MetadataManager
implements IMetadataManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MetadataCache cache = new MetadataCache();
    protected final Collection<IAsterixStateProxy> proxies;
    protected IMetadataNode metadataNode;
    protected boolean rebindMetadataNode = false;
    public static IMetadataManager INSTANCE;

    private MetadataManager(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
        this(proxies);
        if (metadataNode == null) {
            throw new IllegalArgumentException("Null metadataNode given to MetadataManager");
        }
        this.metadataNode = metadataNode;
    }

    private MetadataManager(Collection<IAsterixStateProxy> proxies) {
        if (proxies == null || proxies.isEmpty()) {
            throw new IllegalArgumentException("Null / empty list of proxies given to MetadataManager");
        }
        this.proxies = proxies;
    }

    protected abstract TxnId createTxnId();

    public void init() throws HyracksDataException {
    }

    @Override
    public MetadataTransactionContext beginTransaction() throws RemoteException {
        try {
            INSTANCE.init();
        }
        catch (HyracksDataException e) {
            throw new ACIDException((Throwable)e);
        }
        TxnId txnId = this.createTxnId();
        this.metadataNode.beginTransaction(txnId);
        return new MetadataTransactionContext(txnId);
    }

    @Override
    public void commitTransaction(MetadataTransactionContext ctx) {
        try {
            this.metadataNode.commitTransaction(ctx.getTxnId());
            this.cache.commit(ctx);
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure committing a metadata transaction", th);
            ExitUtil.halt((int)6);
        }
    }

    @Override
    public void abortTransaction(MetadataTransactionContext ctx) {
        try {
            this.metadataNode.abortTransaction(ctx.getTxnId());
        }
        catch (Throwable th) {
            LOGGER.fatal("Failure aborting a metadata transaction", th);
            ExitUtil.halt((int)7);
        }
    }

    @Override
    public Database getDatabase(MetadataTransactionContext ctx, String databaseName) throws AlgebricksException {
        Objects.requireNonNull(databaseName);
        Database database = ctx.getDatabase(databaseName);
        if (database != null) {
            return database;
        }
        if (ctx.databaseIsDropped(databaseName)) {
            return null;
        }
        database = this.cache.getDatabase(databaseName);
        if (database != null) {
            return database;
        }
        try {
            database = this.metadataNode.getDatabase(ctx.getTxnId(), databaseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (database != null) {
            ctx.addDatabase(database);
        }
        return database;
    }

    @Override
    public void addDatabase(MetadataTransactionContext ctx, Database database) throws AlgebricksException {
        try {
            this.metadataNode.addDatabase(ctx.getTxnId(), database);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addDatabase(database);
    }

    @Override
    public void dropDatabase(MetadataTransactionContext ctx, String databaseName) throws AlgebricksException {
        try {
            Objects.requireNonNull(databaseName);
            this.metadataNode.dropDatabase(ctx.getTxnId(), databaseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDatabase(databaseName);
    }

    @Override
    public void addDataverse(MetadataTransactionContext ctx, Dataverse dataverse) throws AlgebricksException {
        try {
            this.metadataNode.addDataverse(ctx.getTxnId(), dataverse);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addDataverse(dataverse);
    }

    @Override
    public void dropDataverse(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropDataverse(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataverse(database, dataverseName);
    }

    @Override
    public boolean isDataverseNotEmpty(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.isDataverseNotEmpty(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Database> getDatabases(MetadataTransactionContext ctx) throws AlgebricksException {
        try {
            return this.metadataNode.getDatabases(ctx.getTxnId());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Dataverse> getDataverses(MetadataTransactionContext ctx) throws AlgebricksException {
        try {
            return this.metadataNode.getDataverses(ctx.getTxnId());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public Dataverse getDataverse(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        Objects.requireNonNull(database);
        Dataverse dataverse = ctx.getDataverse(database, dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        if (ctx.dataverseIsDropped(database, dataverseName)) {
            return null;
        }
        dataverse = this.cache.getDataverse(database, dataverseName);
        if (dataverse != null) {
            return dataverse;
        }
        try {
            dataverse = this.metadataNode.getDataverse(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dataverse != null) {
            ctx.addDataverse(dataverse);
        }
        return dataverse;
    }

    @Override
    public List<Dataset> getDatabaseDatasets(MetadataTransactionContext ctx, String database) throws AlgebricksException {
        List<Dataset> databaseDatasets;
        try {
            Objects.requireNonNull(database);
            databaseDatasets = this.metadataNode.getDatabaseDatasets(ctx.getTxnId(), database);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return databaseDatasets;
    }

    @Override
    public List<Dataset> getDataverseDatasets(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        List<Dataset> dataverseDatasets;
        try {
            Objects.requireNonNull(database);
            dataverseDatasets = this.metadataNode.getDataverseDatasets(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseDatasets;
    }

    @Override
    public void addDataset(MetadataTransactionContext ctx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.addDataset(ctx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addDataset(dataset);
    }

    @Override
    public void dropDataset(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName, boolean force) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropDataset(ctx.getTxnId(), database, dataverseName, datasetName, force);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataset(database, dataverseName, datasetName);
    }

    @Override
    public Dataset getDataset(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        Objects.requireNonNull(database);
        Dataset dataset = ctx.getDataset(database, dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        if (ctx.datasetIsDropped(database, dataverseName, datasetName)) {
            return null;
        }
        dataset = this.cache.getDataset(database, dataverseName, datasetName);
        if (dataset != null) {
            return dataset;
        }
        try {
            dataset = this.metadataNode.getDataset(ctx.getTxnId(), database, dataverseName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dataset != null) {
            ctx.addDataset(dataset);
        }
        return dataset;
    }

    @Override
    public List<Index> getDatasetIndexes(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        List<Index> datasetIndexes;
        Objects.requireNonNull(database);
        Dataset dataset = this.getDataset(ctx, database, dataverseName, datasetName);
        if (dataset == null) {
            return Collections.emptyList();
        }
        try {
            datasetIndexes = this.metadataNode.getDatasetIndexes(ctx.getTxnId(), database, dataverseName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return datasetIndexes;
    }

    @Override
    public void addCompactionPolicy(MetadataTransactionContext mdTxnCtx, CompactionPolicy compactionPolicy) throws AlgebricksException {
        try {
            this.metadataNode.addCompactionPolicy(mdTxnCtx.getTxnId(), compactionPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addCompactionPolicy(compactionPolicy);
    }

    @Override
    public CompactionPolicy getCompactionPolicy(MetadataTransactionContext ctx, String database, DataverseName dataverse, String policyName) throws AlgebricksException {
        CompactionPolicy compactionPolicy;
        try {
            Objects.requireNonNull(database);
            compactionPolicy = this.metadataNode.getCompactionPolicy(ctx.getTxnId(), database, dataverse, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return compactionPolicy;
    }

    @Override
    public void addDatatype(MetadataTransactionContext ctx, Datatype datatype) throws AlgebricksException {
        try {
            this.metadataNode.addDatatype(ctx.getTxnId(), datatype);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        try {
            ctx.addDatatype(this.metadataNode.getDatatype(ctx.getTxnId(), datatype.getDatabaseName(), datatype.getDataverseName(), datatype.getDatatypeName()));
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropDatatype(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropDatatype(ctx.getTxnId(), database, dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataDatatype(database, dataverseName, datatypeName);
    }

    @Override
    public Datatype getDatatype(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        Objects.requireNonNull(database);
        Datatype datatype = ctx.getDatatype(database, dataverseName, datatypeName);
        if (datatype != null) {
            return datatype;
        }
        if (ctx.datatypeIsDropped(database, dataverseName, datatypeName)) {
            return null;
        }
        datatype = this.cache.getDatatype(database, dataverseName, datatypeName);
        if (datatype != null) {
            return datatype;
        }
        try {
            datatype = this.metadataNode.getDatatype(ctx.getTxnId(), database, dataverseName, datatypeName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (datatype != null) {
            ctx.addDatatype(datatype);
        }
        return datatype;
    }

    @Override
    public void addIndex(MetadataTransactionContext ctx, Index index) throws AlgebricksException {
        try {
            this.metadataNode.addIndex(ctx.getTxnId(), index);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addIndex(index);
    }

    @Override
    public void addAdapter(MetadataTransactionContext mdTxnCtx, DatasourceAdapter adapter) throws AlgebricksException {
        try {
            this.metadataNode.addAdapter(mdTxnCtx.getTxnId(), adapter);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addAdapter(adapter);
    }

    @Override
    public void dropIndex(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropIndex(ctx.getTxnId(), database, dataverseName, datasetName, indexName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropIndex(database, dataverseName, datasetName, indexName);
    }

    @Override
    public Index getIndex(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName, String indexName) throws AlgebricksException {
        Objects.requireNonNull(database);
        Index index = ctx.getIndex(database, dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        if (ctx.indexIsDropped(database, dataverseName, datasetName, indexName)) {
            return null;
        }
        index = this.cache.getIndex(database, dataverseName, datasetName, indexName);
        if (index != null) {
            return index;
        }
        try {
            index = this.metadataNode.getIndex(ctx.getTxnId(), database, dataverseName, datasetName, indexName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (index != null) {
            ctx.addIndex(index);
        }
        return index;
    }

    @Override
    public void addNode(MetadataTransactionContext ctx, Node node) throws AlgebricksException {
        try {
            this.metadataNode.addNode(ctx.getTxnId(), node);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void addNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup) throws AlgebricksException {
        this.modifyNodegroup(ctx, nodeGroup, AbstractIndexModificationOperationCallback.Operation.INSERT);
    }

    @Override
    public void upsertNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup) throws AlgebricksException {
        this.modifyNodegroup(ctx, nodeGroup, AbstractIndexModificationOperationCallback.Operation.UPSERT);
    }

    private void modifyNodegroup(MetadataTransactionContext ctx, NodeGroup nodeGroup, AbstractIndexModificationOperationCallback.Operation op) throws AlgebricksException {
        try {
            this.metadataNode.modifyNodeGroup(ctx.getTxnId(), nodeGroup, op);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addNodeGroup(nodeGroup);
    }

    @Override
    public void dropNodegroup(MetadataTransactionContext ctx, String nodeGroupName, boolean failSilently) throws AlgebricksException {
        boolean dropped;
        try {
            dropped = this.metadataNode.dropNodegroup(ctx.getTxnId(), nodeGroupName, failSilently);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (dropped) {
            ctx.dropNodeGroup(nodeGroupName);
        }
    }

    @Override
    public NodeGroup getNodegroup(MetadataTransactionContext ctx, String nodeGroupName) throws AlgebricksException {
        NodeGroup nodeGroup = ctx.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        if (ctx.nodeGroupIsDropped(nodeGroupName)) {
            return null;
        }
        nodeGroup = this.cache.getNodeGroup(nodeGroupName);
        if (nodeGroup != null) {
            return nodeGroup;
        }
        try {
            nodeGroup = this.metadataNode.getNodeGroup(ctx.getTxnId(), nodeGroupName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (nodeGroup != null) {
            ctx.addNodeGroup(nodeGroup);
        }
        return nodeGroup;
    }

    @Override
    public void addFunction(MetadataTransactionContext mdTxnCtx, Function function) throws AlgebricksException {
        try {
            this.metadataNode.addFunction(mdTxnCtx.getTxnId(), function);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFunction(function);
    }

    @Override
    public void dropFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws AlgebricksException {
        try {
            this.metadataNode.dropFunction(ctx.getTxnId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFunction(functionSignature);
    }

    @Override
    public Function getFunction(MetadataTransactionContext ctx, FunctionSignature functionSignature) throws AlgebricksException {
        Function function = ctx.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        if (ctx.functionIsDropped(functionSignature)) {
            return null;
        }
        if (ctx.getDataverse(functionSignature.getDatabaseName(), functionSignature.getDataverseName()) != null) {
            return null;
        }
        function = this.cache.getFunction(functionSignature);
        if (function != null) {
            return function;
        }
        try {
            function = this.metadataNode.getFunction(ctx.getTxnId(), functionSignature);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (function != null) {
            ctx.addFunction(function);
        }
        return function;
    }

    @Override
    public List<Function> getDataverseFunctions(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.getDataverseFunctions(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void addFullTextFilter(MetadataTransactionContext mdTxnCtx, FullTextFilterMetadataEntity filter) throws AlgebricksException {
        try {
            this.metadataNode.addFullTextFilter(mdTxnCtx.getTxnId(), filter);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFullTextFilter(filter);
    }

    @Override
    public void dropFullTextFilter(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String filterName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropFullTextFilter(mdTxnCtx.getTxnId(), database, dataverseName, filterName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFullTextFilter(database, dataverseName, filterName);
    }

    @Override
    public FullTextFilterMetadataEntity getFullTextFilter(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String filterName) throws AlgebricksException {
        Objects.requireNonNull(database);
        FullTextFilterMetadataEntity filter = ctx.getFullTextFilter(database, dataverseName, filterName);
        if (filter != null) {
            return filter;
        }
        if (ctx.fullTextFilterIsDropped(database, dataverseName, filterName)) {
            return null;
        }
        if (ctx.getDataverse(database, dataverseName) != null) {
            return null;
        }
        filter = this.cache.getFullTextFilter(database, dataverseName, filterName);
        if (filter != null) {
            return filter;
        }
        try {
            filter = this.metadataNode.getFullTextFilter(ctx.getTxnId(), database, dataverseName, filterName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (filter != null) {
            ctx.addFullTextFilter(filter);
        }
        return filter;
    }

    @Override
    public void addFullTextConfig(MetadataTransactionContext mdTxnCtx, FullTextConfigMetadataEntity configMetadataEntity) throws AlgebricksException {
        if (Strings.isNullOrEmpty((String)configMetadataEntity.getFullTextConfig().getName())) {
            throw new MetadataException(ErrorCode.FULL_TEXT_CONFIG_ALREADY_EXISTS, new Serializable[0]);
        }
        try {
            this.metadataNode.addFullTextConfig(mdTxnCtx.getTxnId(), configMetadataEntity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFullTextConfig(configMetadataEntity);
    }

    @Override
    public FullTextConfigMetadataEntity getFullTextConfig(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String configName) throws AlgebricksException {
        Objects.requireNonNull(database);
        FullTextConfigMetadataEntity configMetadataEntity = ctx.getFullTextConfig(database, dataverseName, configName);
        if (configMetadataEntity != null) {
            return configMetadataEntity;
        }
        if (ctx.fullTextConfigIsDropped(database, dataverseName, configName)) {
            return null;
        }
        if (ctx.getDataverse(database, dataverseName) != null) {
            return null;
        }
        configMetadataEntity = this.cache.getFullTextConfig(database, dataverseName, configName);
        if (configMetadataEntity != null) {
            return configMetadataEntity;
        }
        try {
            configMetadataEntity = this.metadataNode.getFullTextConfig(ctx.getTxnId(), database, dataverseName, configName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        if (configMetadataEntity != null) {
            ctx.addFullTextConfig(configMetadataEntity);
        }
        return configMetadataEntity;
    }

    @Override
    public void dropFullTextConfig(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String configName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropFullTextConfig(mdTxnCtx.getTxnId(), database, dataverseName, configName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFullTextConfig(database, dataverseName, configName);
    }

    @Override
    public void addFeedPolicy(MetadataTransactionContext mdTxnCtx, FeedPolicyEntity feedPolicy) throws AlgebricksException {
        try {
            this.metadataNode.addFeedPolicy(mdTxnCtx.getTxnId(), feedPolicy);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.addFeedPolicy(feedPolicy);
    }

    @Override
    public void initializeDatasetIdFactory(MetadataTransactionContext ctx) throws AlgebricksException {
        try {
            this.metadataNode.initializeDatasetIdFactory(ctx.getTxnId());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public int getMostRecentDatasetId() throws AlgebricksException {
        try {
            return this.metadataNode.getMostRecentDatasetId();
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropAdapter(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String name) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropAdapter(ctx.getTxnId(), database, dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropAdapter(database, dataverseName, name);
    }

    @Override
    public DatasourceAdapter getAdapter(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String name) throws AlgebricksException {
        DatasourceAdapter adapter;
        try {
            Objects.requireNonNull(database);
            adapter = this.metadataNode.getAdapter(ctx.getTxnId(), database, dataverseName, name);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return adapter;
    }

    @Override
    public void dropLibrary(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropLibrary(ctx.getTxnId(), database, dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropLibrary(database, dataverseName, libraryName);
    }

    @Override
    public List<Library> getDatabaseLibraries(MetadataTransactionContext ctx, String database) throws AlgebricksException {
        List<Library> databaseLibraries;
        try {
            Objects.requireNonNull(database);
            databaseLibraries = this.metadataNode.getDatabaseLibraries(ctx.getTxnId(), database);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return databaseLibraries;
    }

    @Override
    public List<Library> getDataverseLibraries(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        List<Library> dataverseLibaries;
        try {
            Objects.requireNonNull(database);
            dataverseLibaries = this.metadataNode.getDataverseLibraries(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseLibaries;
    }

    @Override
    public void addLibrary(MetadataTransactionContext ctx, Library library) throws AlgebricksException {
        try {
            this.metadataNode.addLibrary(ctx.getTxnId(), library);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addLibrary(library);
    }

    @Override
    public Library getLibrary(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        Library library;
        try {
            Objects.requireNonNull(database);
            library = this.metadataNode.getLibrary(ctx.getTxnId(), database, dataverseName, libraryName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return library;
    }

    @Override
    public FeedPolicyEntity getFeedPolicy(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        FeedPolicyEntity feedPolicy;
        try {
            Objects.requireNonNull(database);
            feedPolicy = this.metadataNode.getFeedPolicy(ctx.getTxnId(), database, dataverseName, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feedPolicy;
    }

    @Override
    public Feed getFeed(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        Feed feed;
        try {
            Objects.requireNonNull(database);
            feed = this.metadataNode.getFeed(ctx.getTxnId(), database, dataverseName, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feed;
    }

    @Override
    public List<Feed> getFeeds(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        List<Feed> feeds;
        try {
            Objects.requireNonNull(database);
            feeds = this.metadataNode.getFeeds(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return feeds;
    }

    @Override
    public void dropFeed(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        Feed feed;
        try {
            Objects.requireNonNull(database);
            feed = this.metadataNode.getFeed(ctx.getTxnId(), database, dataverseName, feedName);
            List<FeedConnection> feedConnections = this.metadataNode.getFeedConnections(ctx.getTxnId(), database, dataverseName, feedName);
            this.metadataNode.dropFeed(ctx.getTxnId(), database, dataverseName, feedName);
            for (FeedConnection feedConnection : feedConnections) {
                this.metadataNode.dropFeedConnection(ctx.getTxnId(), database, dataverseName, feedName, feedConnection.getDatasetName());
                ctx.dropFeedConnection(database, dataverseName, feedName, feedConnection.getDatasetName());
            }
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeed(feed);
    }

    @Override
    public void addFeed(MetadataTransactionContext ctx, Feed feed) throws AlgebricksException {
        try {
            this.metadataNode.addFeed(ctx.getTxnId(), feed);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeed(feed);
    }

    @Override
    public void addFeedConnection(MetadataTransactionContext ctx, FeedConnection feedConnection) throws AlgebricksException {
        try {
            this.metadataNode.addFeedConnection(ctx.getTxnId(), feedConnection);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.addFeedConnection(feedConnection);
    }

    @Override
    public void dropFeedConnection(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropFeedConnection(ctx.getTxnId(), database, dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFeedConnection(database, dataverseName, feedName, datasetName);
    }

    @Override
    public FeedConnection getFeedConnection(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String feedName, String datasetName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.getFeedConnection(ctx.getTxnId(), database, dataverseName, feedName, datasetName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<FeedConnection> getFeedConections(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String feedName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.getFeedConnections(ctx.getTxnId(), database, dataverseName, feedName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<DatasourceAdapter> getDataverseAdapters(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName) throws AlgebricksException {
        List<DatasourceAdapter> dataverseAdapters;
        try {
            Objects.requireNonNull(database);
            dataverseAdapters = this.metadataNode.getDataverseAdapters(mdTxnCtx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseAdapters;
    }

    @Override
    public void dropFeedPolicy(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName, String policyName) throws AlgebricksException {
        FeedPolicyEntity feedPolicy;
        try {
            Objects.requireNonNull(database);
            feedPolicy = this.metadataNode.getFeedPolicy(mdTxnCtx.getTxnId(), database, dataverseName, policyName);
            this.metadataNode.dropFeedPolicy(mdTxnCtx.getTxnId(), database, dataverseName, policyName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        mdTxnCtx.dropFeedPolicy(feedPolicy);
    }

    @Override
    public List<FeedPolicyEntity> getDataverseFeedPolicies(MetadataTransactionContext mdTxnCtx, String database, DataverseName dataverseName) throws AlgebricksException {
        List<FeedPolicyEntity> dataverseFeedPolicies;
        try {
            Objects.requireNonNull(database);
            dataverseFeedPolicies = this.metadataNode.getDataverseFeedPolicies(mdTxnCtx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return dataverseFeedPolicies;
    }

    @Override
    public List<ExternalFile> getDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws AlgebricksException {
        List<ExternalFile> externalFiles;
        try {
            externalFiles = this.metadataNode.getExternalFiles(mdTxnCtx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return externalFiles;
    }

    @Override
    public void addExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws AlgebricksException {
        try {
            this.metadataNode.addExternalFile(ctx.getTxnId(), externalFile);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropExternalFile(MetadataTransactionContext ctx, ExternalFile externalFile) throws AlgebricksException {
        try {
            this.metadataNode.dropExternalFile(ctx.getTxnId(), externalFile.getDatabaseName(), externalFile.getDataverseName(), externalFile.getDatasetName(), externalFile.getFileNumber());
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public ExternalFile getExternalFile(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String datasetName, Integer fileNumber) throws AlgebricksException {
        ExternalFile file;
        try {
            Objects.requireNonNull(database);
            file = this.metadataNode.getExternalFile(ctx.getTxnId(), database, dataverseName, datasetName, fileNumber);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        return file;
    }

    @Override
    public void addSynonym(MetadataTransactionContext ctx, Synonym synonym) throws AlgebricksException {
        try {
            this.metadataNode.addSynonym(ctx.getTxnId(), synonym);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropSynonym(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            this.metadataNode.dropSynonym(ctx.getTxnId(), database, dataverseName, synonymName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public Synonym getSynonym(MetadataTransactionContext ctx, String database, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.getSynonym(ctx.getTxnId(), database, dataverseName, synonymName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public List<Synonym> getDataverseSynonyms(MetadataTransactionContext ctx, String database, DataverseName dataverseName) throws AlgebricksException {
        try {
            Objects.requireNonNull(database);
            return this.metadataNode.getDataverseSynonyms(ctx.getTxnId(), database, dataverseName);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void dropDatasetExternalFiles(MetadataTransactionContext mdTxnCtx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.dropExternalFiles(mdTxnCtx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void updateDataset(MetadataTransactionContext ctx, Dataset dataset) throws AlgebricksException {
        try {
            this.metadataNode.updateDataset(ctx.getTxnId(), dataset);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataset(dataset.getDatabaseName(), dataset.getDataverseName(), dataset.getDatasetName());
        ctx.addDataset(dataset);
    }

    @Override
    public void updateLibrary(MetadataTransactionContext ctx, Library library) throws AlgebricksException {
        try {
            this.metadataNode.updateLibrary(ctx.getTxnId(), library);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropLibrary(library.getDatabaseName(), library.getDataverseName(), library.getName());
        ctx.addLibrary(library);
    }

    @Override
    public void updateFunction(MetadataTransactionContext ctx, Function function) throws AlgebricksException {
        try {
            this.metadataNode.updateFunction(ctx.getTxnId(), function);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropFunction(function.getSignature());
        ctx.addFunction(function);
    }

    @Override
    public void updateDatatype(MetadataTransactionContext ctx, Datatype datatype) throws AlgebricksException {
        try {
            this.metadataNode.updateDatatype(ctx.getTxnId(), datatype);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
        ctx.dropDataDatatype(datatype.getDatabaseName(), datatype.getDataverseName(), datatype.getDatatypeName());
        ctx.addDatatype(datatype);
    }

    @Override
    public <T extends IExtensionMetadataEntity> void addEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.addEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void upsertEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.upsertEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> void deleteEntity(MetadataTransactionContext mdTxnCtx, T entity) throws AlgebricksException {
        try {
            this.metadataNode.deleteEntity(mdTxnCtx.getTxnId(), entity);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public <T extends IExtensionMetadataEntity> List<T> getEntities(MetadataTransactionContext mdTxnCtx, IExtensionMetadataSearchKey searchKey) throws AlgebricksException {
        try {
            return this.metadataNode.getEntities(mdTxnCtx.getTxnId(), searchKey);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public JsonNode getEntitiesAsJson(MetadataTransactionContext mdTxnCtx, IMetadataIndex metadataIndex, int payloadPosition) throws AlgebricksException {
        try {
            return this.metadataNode.getEntitiesAsJson(mdTxnCtx.getTxnId(), metadataIndex, payloadPosition);
        }
        catch (RemoteException e) {
            throw new MetadataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
        }
    }

    @Override
    public void rebindMetadataNode() {
        this.rebindMetadataNode = true;
    }

    public static void initialize(IAsterixStateProxy proxy, MetadataProperties metadataProperties, ICcApplicationContext appCtx) {
        INSTANCE = new CCMetadataManagerImpl(proxy, metadataProperties, appCtx);
    }

    public static void initialize(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
        INSTANCE = new NCMetadataManagerImpl(proxies, metadataNode);
    }

    private static class CCMetadataManagerImpl
    extends MetadataManager {
        private final MetadataProperties metadataProperties;
        private final ICcApplicationContext appCtx;

        CCMetadataManagerImpl(IAsterixStateProxy proxy, MetadataProperties metadataProperties, ICcApplicationContext appCtx) {
            super(Collections.singleton(proxy));
            this.metadataProperties = metadataProperties;
            this.appCtx = appCtx;
        }

        @Override
        protected TxnId createTxnId() {
            TxnId txnId;
            try {
                txnId = this.appCtx.getTxnIdFactory().create();
            }
            catch (AlgebricksException e) {
                throw new ACIDException((Throwable)e);
            }
            return txnId;
        }

        @Override
        public long getMaxTxnId() {
            return this.appCtx.getTxnIdFactory().getMaxTxnId();
        }

        @Override
        public synchronized void init() throws HyracksDataException {
            if (this.metadataNode != null && !this.rebindMetadataNode) {
                return;
            }
            try {
                this.metadataNode = ((IAsterixStateProxy)this.proxies.iterator().next()).waitForMetadataNode(this.metadataProperties.getRegistrationTimeoutSecs(), TimeUnit.SECONDS);
                if (this.metadataNode == null) {
                    throw new HyracksDataException("The MetadataNode failed to bind before the configured timeout (" + this.metadataProperties.getRegistrationTimeoutSecs() + " seconds); the MetadataNode was configured to run on NC: " + this.metadataProperties.getMetadataNodeName());
                }
                this.rebindMetadataNode = false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HyracksDataException.create((Throwable)e);
            }
            catch (RemoteException e) {
                throw new RuntimeDataException(ErrorCode.REMOTE_EXCEPTION_WHEN_CALLING_METADATA_NODE, (Throwable)e, new Serializable[0]);
            }
            super.init();
        }
    }

    private static class NCMetadataManagerImpl
    extends MetadataManager {
        private final ITxnIdFactory txnIdFactory;

        NCMetadataManagerImpl(Collection<IAsterixStateProxy> proxies, MetadataNode metadataNode) {
            super(proxies, metadataNode);
            this.txnIdFactory = metadataNode.getTxnIdFactory();
        }

        @Override
        protected TxnId createTxnId() {
            try {
                return this.txnIdFactory.create();
            }
            catch (AlgebricksException e) {
                throw new ACIDException((Throwable)e);
            }
        }

        @Override
        public long getMaxTxnId() {
            return this.txnIdFactory.getMaxTxnId();
        }
    }
}

