/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.model;

import java.util.AbstractList;
import java.util.Iterator;
import org.openjdk.tools.javac.code.Scope;
import org.openjdk.tools.javac.code.Symbol;

public class FilteredMemberList
extends AbstractList<Symbol> {
    private final Scope scope;

    public FilteredMemberList(Scope scope) {
        this.scope = scope;
    }

    @Override
    public int size() {
        int n = 0;
        for (Symbol symbol : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(symbol)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Symbol get(int n) {
        for (Symbol symbol : this.scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (FilteredMemberList.unwanted(symbol) || n-- != 0) continue;
            return symbol;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Iterator<Symbol> iterator() {
        return this.scope.getSymbols(symbol -> !FilteredMemberList.unwanted(symbol), Scope.LookupKind.NON_RECURSIVE).iterator();
    }

    private static boolean unwanted(Symbol symbol) {
        return symbol == null || (symbol.flags() & 0x1000L) != 0L;
    }
}

