/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Automatically convert speech to text using AWS Transcribe service
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Transcribe2EndpointBuilderFactory {

    /**
     * Builder for endpoint for the AWS Transcribe component.
     */
    public interface Transcribe2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTranscribe2EndpointBuilder advanced() {
            return (AdvancedTranscribe2EndpointBuilder) this;
        }

        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws2.transcribe.Transcribe2Operations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder operation(org.apache.camel.component.aws2.transcribe.Transcribe2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws2.transcribe.Transcribe2Operations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with uriEndpointOverride option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder pojoRequest(String pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
        /**
         * If using a profile credentials provider this parameter will set the
         * profile name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Transcribe client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder protocol(software.amazon.awssdk.core.Protocol protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Transcribe client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param protocol the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder protocol(String protocol) {
            doSetProperty("protocol", protocol);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Transcribe client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Transcribe client.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Transcribe client.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Transcribe client.
         * 
         * The option is a: <code>software.amazon.awssdk.core.Protocol</code>
         * type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Transcribe client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.core.Protocol</code> type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which Transcribe client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * To use a existing configured AWS Transcribe as client.
         * 
         * The option is a:
         * <code>software.amazon.awssdk.services.transcribe.TranscribeClient</code> type.
         * 
         * Group: producer
         * 
         * @param transcribeClient the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder transcribeClient(software.amazon.awssdk.services.transcribe.TranscribeClient transcribeClient) {
            doSetProperty("transcribeClient", transcribeClient);
            return this;
        }
        /**
         * To use a existing configured AWS Transcribe as client.
         * 
         * The option will be converted to a
         * <code>software.amazon.awssdk.services.transcribe.TranscribeClient</code> type.
         * 
         * Group: producer
         * 
         * @param transcribeClient the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder transcribeClient(String transcribeClient) {
            doSetProperty("transcribeClient", transcribeClient);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume a IAM role for doing the operations.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Set whether the Transcribe client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume a IAM role for doing the operations.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * To define a proxy password when instantiating the Transcribe client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param proxyPassword the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyPassword(String proxyPassword) {
            doSetProperty("proxyPassword", proxyPassword);
            return this;
        }
        /**
         * To define a proxy username when instantiating the Transcribe client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param proxyUsername the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder proxyUsername(String proxyUsername) {
            doSetProperty("proxyUsername", proxyUsername);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * Amazon AWS Session Token used when the user needs to assume a IAM
         * role.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder sessionToken(String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Transcribe component.
     */
    public interface AdvancedTranscribe2EndpointBuilder
            extends
                EndpointProducerBuilder {
        default Transcribe2EndpointBuilder basic() {
            return (Transcribe2EndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTranscribe2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedTranscribe2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface Transcribe2Builders {
        /**
         * AWS Transcribe (camel-aws2-transcribe)
         * Automatically convert speech to text using AWS Transcribe service
         * 
         * Category: cloud,messaging
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-transcribe
         * 
         * @return the dsl builder for the headers' name.
         */
        default Transcribe2HeaderNameBuilder aws2Transcribe() {
            return Transcribe2HeaderNameBuilder.INSTANCE;
        }
        /**
         * AWS Transcribe (camel-aws2-transcribe)
         * Automatically convert speech to text using AWS Transcribe service
         * 
         * Category: cloud,messaging
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-transcribe
         * 
         * Syntax: <code>aws2-transcribe:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder aws2Transcribe(String path) {
            return Transcribe2EndpointBuilderFactory.endpointBuilder("aws2-transcribe", path);
        }
        /**
         * AWS Transcribe (camel-aws2-transcribe)
         * Automatically convert speech to text using AWS Transcribe service
         * 
         * Category: cloud,messaging
         * Since: 4.15
         * Maven coordinates: org.apache.camel:camel-aws2-transcribe
         * 
         * Syntax: <code>aws2-transcribe:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default Transcribe2EndpointBuilder aws2Transcribe(String componentName, String path) {
            return Transcribe2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the AWS Transcribe component.
     */
    public static class Transcribe2HeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final Transcribe2HeaderNameBuilder INSTANCE = new Transcribe2HeaderNameBuilder();

        /**
         * The name of the transcription job.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTranscribeTranscriptionJobName}.
         */
        public String awsTranscribeTranscriptionJobName() {
            return "CamelAwsTranscribeTranscriptionJobName";
        }
        /**
         * The language code for the transcription job.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeLanguageCode}.
         */
        public String awsTranscribeLanguageCode() {
            return "CamelAwsTranscribeLanguageCode";
        }
        /**
         * The format of the input media file.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeMediaFormat}.
         */
        public String awsTranscribeMediaFormat() {
            return "CamelAwsTranscribeMediaFormat";
        }
        /**
         * The URI of the media file to transcribe.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeMediaUri}.
         */
        public String awsTranscribeMediaUri() {
            return "CamelAwsTranscribeMediaUri";
        }
        /**
         * Filter transcription jobs by name containing this string.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeJobNameContains}.
         */
        public String awsTranscribeJobNameContains() {
            return "CamelAwsTranscribeJobNameContains";
        }
        /**
         * The status of the transcription job.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeStatus}.
         */
        public String awsTranscribeStatus() {
            return "CamelAwsTranscribeStatus";
        }
        /**
         * The name of the custom vocabulary to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeVocabularyName}.
         */
        public String awsTranscribeVocabularyName() {
            return "CamelAwsTranscribeVocabularyName";
        }
        /**
         * The name of the vocabulary filter to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTranscribeVocabularyFilterName}.
         */
        public String awsTranscribeVocabularyFilterName() {
            return "CamelAwsTranscribeVocabularyFilterName";
        }
        /**
         * List of phrases for custom vocabulary.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTranscribeVocabularyPhrases}.
         */
        public String awsTranscribeVocabularyPhrases() {
            return "CamelAwsTranscribeVocabularyPhrases";
        }
        /**
         * The name of the custom language model to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTranscribeLanguageModelName}.
         */
        public String awsTranscribeLanguageModelName() {
            return "CamelAwsTranscribeLanguageModelName";
        }
        /**
         * The name of the medical transcription job.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AwsTranscribeMedicalTranscriptionJobName}.
         */
        public String awsTranscribeMedicalTranscriptionJobName() {
            return "CamelAwsTranscribeMedicalTranscriptionJobName";
        }
        /**
         * The Amazon Resource Name (ARN) of the resource.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeResourceArn}.
         */
        public String awsTranscribeResourceArn() {
            return "CamelAwsTranscribeResourceArn";
        }
        /**
         * A map of tags to assign to the resource.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeTags}.
         */
        public String awsTranscribeTags() {
            return "CamelAwsTranscribeTags";
        }
        /**
         * A list of tag keys to remove from the resource.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AwsTranscribeTagKeys}.
         */
        public String awsTranscribeTagKeys() {
            return "CamelAwsTranscribeTagKeys";
        }
    }
    static Transcribe2EndpointBuilder endpointBuilder(String componentName, String path) {
        class Transcribe2EndpointBuilderImpl extends AbstractEndpointBuilder implements Transcribe2EndpointBuilder, AdvancedTranscribe2EndpointBuilder {
            public Transcribe2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Transcribe2EndpointBuilderImpl(path);
    }
}