/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class ConfigurationAssert {
    public static final String TEST_DIR_NAME = "target/test-classes";
    public static final String OUT_DIR_NAME = "target";
    public static final File TEST_DIR = new File("target/test-classes");
    public static final File OUT_DIR = new File("target");

    public static void assertEquals(Configuration expected, Configuration actual) {
        String key;
        Iterator it = expected.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("The actual configuration doesn't contain the expected key '" + key + "'"), (boolean)actual.containsKey(key));
            Assert.assertEquals((String)("Value of the '" + key + "' property"), (Object)expected.getProperty(key), (Object)actual.getProperty(key));
        }
        it = actual.getKeys();
        while (it.hasNext()) {
            key = (String)it.next();
            Assert.assertTrue((String)("The actual configuration contains an extra key '" + key + "'"), (boolean)expected.containsKey(key));
        }
    }

    public static File getTestFile(String name) {
        return new File(TEST_DIR, name);
    }

    public static File getOutFile(String name) {
        return new File(OUT_DIR, name);
    }

    public static URL getTestURL(String name) {
        return ConfigurationAssert.urlFromFile(ConfigurationAssert.getTestFile(name));
    }

    public static URL getOutURL(String name) {
        return ConfigurationAssert.urlFromFile(ConfigurationAssert.getOutFile(name));
    }

    private static URL urlFromFile(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException mex) {
            throw new ConfigurationRuntimeException((Throwable)mex);
        }
    }
}

