/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.tree.xpath;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.configuration.tree.NodeAddData;
import org.apache.commons.configuration.tree.xpath.ConfigurationNodePointerFactory;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestXPathExpressionEngine {
    static final ConfigurationNode ROOT = new DefaultConfigurationNode("testRoot");
    static final String TEST_KEY = "TESTKEY";
    XPathExpressionEngine engine;

    @Before
    public void setUp() throws Exception {
        this.engine = new MockJXPathContextExpressionEngine();
    }

    @Test
    public void testQueryExpression() {
        List nodes = this.engine.query(ROOT, TEST_KEY);
        Assert.assertEquals((String)"Incorrect number of results", (long)1L, (long)nodes.size());
        Assert.assertSame((String)"Wrong result node", (Object)ROOT, nodes.get(0));
        this.checkSelectCalls(1);
    }

    @Test
    public void testQueryWithoutResult() {
        List nodes = this.engine.query(ROOT, "a non existing key");
        Assert.assertTrue((String)"Result list is not empty", (boolean)nodes.isEmpty());
        this.checkSelectCalls(1);
    }

    @Test
    public void testQueryWithEmptyKey() {
        this.checkEmptyKey("");
    }

    @Test
    public void testQueryWithNullKey() {
        this.checkEmptyKey(null);
    }

    private void checkEmptyKey(String key) {
        List nodes = this.engine.query(ROOT, key);
        Assert.assertEquals((String)"Incorrect number of results", (long)1L, (long)nodes.size());
        Assert.assertSame((String)"Wrong result node", (Object)ROOT, nodes.get(0));
        this.checkSelectCalls(0);
    }

    @Test
    public void testCreateContext() {
        JXPathContext ctx = new XPathExpressionEngine().createContext(ROOT, TEST_KEY);
        Assert.assertNotNull((String)"Context is null", (Object)ctx);
        Assert.assertTrue((String)"Lenient mode is not set", (boolean)ctx.isLenient());
        Assert.assertSame((String)"Incorrect context bean set", (Object)ROOT, (Object)ctx.getContextBean());
        NodePointerFactory[] factories = JXPathContextReferenceImpl.getNodePointerFactories();
        boolean found = false;
        for (int i = 0; i < factories.length; ++i) {
            if (!(factories[i] instanceof ConfigurationNodePointerFactory)) continue;
            found = true;
        }
        Assert.assertTrue((String)"No configuration pointer factory found", (boolean)found);
    }

    @Test
    public void testNodeKeyNormal() {
        Assert.assertEquals((String)"Wrong node key", (Object)"parent/child", (Object)this.engine.nodeKey((ConfigurationNode)new DefaultConfigurationNode("child"), "parent"));
    }

    @Test
    public void testNodeKeyAttribute() {
        DefaultConfigurationNode node = new DefaultConfigurationNode("attr");
        node.setAttribute(true);
        Assert.assertEquals((String)"Wrong attribute key", (Object)"node/@attr", (Object)this.engine.nodeKey((ConfigurationNode)node, "node"));
    }

    @Test
    public void testNodeKeyForRootNode() {
        Assert.assertEquals((String)"Wrong key for root node", (Object)"", (Object)this.engine.nodeKey(ROOT, null));
        Assert.assertEquals((String)"Null name not detected", (Object)"test", (Object)this.engine.nodeKey((ConfigurationNode)new DefaultConfigurationNode(), "test"));
    }

    @Test
    public void testNodeKeyForRootChild() {
        DefaultConfigurationNode node = new DefaultConfigurationNode("child");
        Assert.assertEquals((String)"Wrong key for root child node", (Object)"child", (Object)this.engine.nodeKey((ConfigurationNode)node, ""));
        node.setAttribute(true);
        Assert.assertEquals((String)"Wrong key for root attribute", (Object)"@child", (Object)this.engine.nodeKey((ConfigurationNode)node, ""));
    }

    @Test
    public void testPrepareAddNode() {
        NodeAddData data = this.engine.prepareAdd(ROOT, "TESTKEY  newNode");
        this.checkAddPath(data, new String[]{"newNode"}, false);
        this.checkSelectCalls(1);
    }

    @Test
    public void testPrepareAddAttribute() {
        NodeAddData data = this.engine.prepareAdd(ROOT, "TESTKEY\t@newAttr");
        this.checkAddPath(data, new String[]{"newAttr"}, true);
        this.checkSelectCalls(1);
    }

    @Test
    public void testPrepareAddPath() {
        NodeAddData data = this.engine.prepareAdd(ROOT, "TESTKEY \t a/full/path/node");
        this.checkAddPath(data, new String[]{"a", "full", "path", "node"}, false);
        this.checkSelectCalls(1);
    }

    @Test
    public void testPrepareAddAttributePath() {
        NodeAddData data = this.engine.prepareAdd(ROOT, "TESTKEY a/full/path@attr");
        this.checkAddPath(data, new String[]{"a", "full", "path", "attr"}, true);
        this.checkSelectCalls(1);
    }

    @Test
    public void testPrepareAddRootChild() {
        NodeAddData data = this.engine.prepareAdd(ROOT, " newNode");
        this.checkAddPath(data, new String[]{"newNode"}, false);
        this.checkSelectCalls(0);
    }

    @Test
    public void testPrepareAddRootAttribute() {
        NodeAddData data = this.engine.prepareAdd(ROOT, " @attr");
        this.checkAddPath(data, new String[]{"attr"}, true);
        this.checkSelectCalls(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidParent() {
        this.engine.prepareAdd(ROOT, "invalidKey newNode");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyPath() {
        this.engine.prepareAdd(ROOT, "TESTKEY ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddNullKey() {
        this.engine.prepareAdd(ROOT, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddEmptyKey() {
        this.engine.prepareAdd(ROOT, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPath() {
        this.engine.prepareAdd(ROOT, "TESTKEY an/invalid//path");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidAttributePath() {
        this.engine.prepareAdd(ROOT, "TESTKEY a/path/with@an/attribute");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidAttributePath2() {
        this.engine.prepareAdd(ROOT, "TESTKEY a/path/with/@attribute");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPathWithSlash() {
        this.engine.prepareAdd(ROOT, "TESTKEY /a/path/node");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrepareAddInvalidPathMultipleAttributes() {
        this.engine.prepareAdd(ROOT, "TESTKEY an@attribute@path");
    }

    private void checkAddPath(NodeAddData data, String[] expected, boolean attr) {
        Assert.assertSame((String)"Wrong parent node", (Object)ROOT, (Object)data.getParent());
        List path = data.getPathNodes();
        Assert.assertEquals((String)"Incorrect number of path nodes", (long)(expected.length - 1), (long)path.size());
        Iterator it = path.iterator();
        for (int idx = 0; idx < expected.length - 1; ++idx) {
            Assert.assertEquals((String)("Wrong node at position " + idx), (Object)expected[idx], it.next());
        }
        Assert.assertEquals((String)"Wrong name of new node", (Object)expected[expected.length - 1], (Object)data.getNewNodeName());
        Assert.assertEquals((String)"Incorrect attribute flag", (Object)attr, (Object)data.isAttribute());
    }

    protected void checkSelectCalls(int expected) {
        MockJXPathContext ctx = ((MockJXPathContextExpressionEngine)this.engine).getContext();
        int calls = ctx == null ? 0 : ctx.selectInvocations;
        Assert.assertEquals((String)"Incorrect number of select calls", (long)expected, (long)calls);
    }

    static class MockJXPathContextExpressionEngine
    extends XPathExpressionEngine {
        private MockJXPathContext context;

        MockJXPathContextExpressionEngine() {
        }

        protected JXPathContext createContext(ConfigurationNode root, String key) {
            this.context = new MockJXPathContext(root);
            return this.context;
        }

        public MockJXPathContext getContext() {
            return this.context;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MockJXPathContext
    extends JXPathContextReferenceImpl {
        int selectInvocations;

        public MockJXPathContext(Object bean) {
            super(null, bean);
        }

        public List<?> selectNodes(String xpath) {
            ++this.selectInvocations;
            if (TestXPathExpressionEngine.TEST_KEY.equals(xpath)) {
                ArrayList<ConfigurationNode> result = new ArrayList<ConfigurationNode>(1);
                result.add(ROOT);
                return result;
            }
            return null;
        }
    }
}

