/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.euclidean.threed.rotation;

import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.euclidean.threed.rotation.AxisSequenceType;

public enum AxisSequence {
    XYZ(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_Z),
    XZY(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_Y),
    YXZ(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Z),
    YZX(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_X),
    ZXY(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Y),
    ZYX(AxisSequenceType.TAIT_BRYAN, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_X),
    XYX(AxisSequenceType.EULER, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_X),
    XZX(AxisSequenceType.EULER, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_X),
    YXY(AxisSequenceType.EULER, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Y),
    YZY(AxisSequenceType.EULER, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_Y),
    ZXZ(AxisSequenceType.EULER, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_X, Vector3D.Unit.PLUS_Z),
    ZYZ(AxisSequenceType.EULER, Vector3D.Unit.PLUS_Z, Vector3D.Unit.PLUS_Y, Vector3D.Unit.PLUS_Z);

    private final AxisSequenceType type;
    private final Vector3D axis1;
    private final Vector3D axis2;
    private final Vector3D axis3;

    private AxisSequence(AxisSequenceType type, Vector3D axis1, Vector3D axis2, Vector3D axis3) {
        this.type = type;
        this.axis1 = axis1;
        this.axis2 = axis2;
        this.axis3 = axis3;
    }

    public AxisSequenceType getType() {
        return this.type;
    }

    public Vector3D getAxis1() {
        return this.axis1;
    }

    public Vector3D getAxis2() {
        return this.axis2;
    }

    public Vector3D getAxis3() {
        return this.axis3;
    }

    public Vector3D[] toArray() {
        return new Vector3D[]{this.axis1, this.axis2, this.axis3};
    }
}

