/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Thread)
@Warmup(iterations=5, time=10)
class StringUtilsIsMixedCaseTest {
    public static final String LOWER_CASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";
    public static final String END_MATCH = "at the enD";
    public static final String Middle_MATCH = "at tHe Mid";
    public static final String EARLY_MATCH = "At tHe beginning";

    StringUtilsIsMixedCaseTest() {
    }

    public static boolean oldIsMixedCase(CharSequence cs) {
        if (StringUtils.isEmpty((CharSequence)cs) || cs.length() == 1) {
            return false;
        }
        boolean containsUppercase = false;
        boolean containsLowercase = false;
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (containsUppercase && containsLowercase) {
                return true;
            }
            if (Character.isUpperCase(cs.charAt(i))) {
                containsUppercase = true;
                continue;
            }
            if (!Character.isLowerCase(cs.charAt(i))) continue;
            containsLowercase = true;
        }
        return containsUppercase && containsLowercase;
    }

    @Benchmark
    public boolean newIsMixedCaseBeginningMatch() {
        return StringUtils.isMixedCase((CharSequence)EARLY_MATCH);
    }

    @Benchmark
    public boolean newIsMixedCaseEndMatch() {
        return StringUtils.isMixedCase((CharSequence)END_MATCH);
    }

    @Benchmark
    public boolean newIsMixedCaseMiddleMatch() {
        return StringUtils.isMixedCase((CharSequence)Middle_MATCH);
    }

    @Benchmark
    public boolean newIsMixedCaseNoneMatch() {
        return StringUtils.isMixedCase((CharSequence)LOWER_CASE_LETTERS);
    }

    @Benchmark
    public boolean oldIsMixedCaseBeginningMatch() {
        return StringUtilsIsMixedCaseTest.oldIsMixedCase(EARLY_MATCH);
    }

    @Benchmark
    public boolean oldIsMixedCaseEndMatch() {
        return StringUtilsIsMixedCaseTest.oldIsMixedCase(END_MATCH);
    }

    @Benchmark
    public boolean oldIsMixedCaseMiddleMatch() {
        return StringUtilsIsMixedCaseTest.oldIsMixedCase(Middle_MATCH);
    }

    @Benchmark
    public boolean oldIsMixedCaseNoneMatch() {
        return StringUtilsIsMixedCaseTest.oldIsMixedCase(LOWER_CASE_LETTERS);
    }
}

