/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;

public final class PropertyHolderFactory {
    private PropertyHolderFactory() {
    }

    public static PropertyHolder getPropertyHolder(Message m) {
        return m.containsKey((Object)"HTTP.REQUEST") ? new ServletRequestPropertyHolder(m) : new MessagePropertyHolder(m);
    }

    private static class MessagePropertyHolder
    implements PropertyHolder {
        private static final String PROPERTY_KEY = "jaxrs.filter.properties";
        private Message m;
        private Map<String, Object> props;

        MessagePropertyHolder(Message m) {
            this.m = m;
            this.props = CastUtils.cast((Map)((Map)m.getExchange().get((Object)PROPERTY_KEY)));
        }

        @Override
        public Object getProperty(String name) {
            return this.props == null ? null : this.props.get(name);
        }

        @Override
        public void removeProperty(String name) {
            if (this.props != null) {
                this.props.remove(name);
            }
        }

        @Override
        public void setProperty(String name, Object value) {
            if (this.props == null) {
                this.props = new HashMap<String, Object>();
                this.m.getExchange().put((Object)PROPERTY_KEY, this.props);
            }
            if (value == null) {
                this.removeProperty(name);
            } else {
                this.props.put(name, value);
            }
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.props == null ? Collections.emptyList() : Collections.unmodifiableSet(this.props.keySet());
        }
    }

    private static class ServletRequestPropertyHolder
    extends MessagePropertyHolder {
        private static final String ENDPOINT_ADDRESS_PROPERTY = "org.apache.cxf.transport.endpoint.address";
        private final HttpServletRequest request;

        ServletRequestPropertyHolder(Message m) {
            super(m);
            this.request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
        }

        @Override
        public Object getProperty(String name) {
            Object value = this.request.getAttribute(name);
            if (value != null) {
                return value;
            }
            return super.getProperty(name);
        }

        @Override
        public void removeProperty(String name) {
            super.removeProperty(name);
            this.request.removeAttribute(name);
        }

        @Override
        public void setProperty(String name, Object value) {
            if (value == null) {
                this.removeProperty(name);
            } else {
                super.setProperty(name, value);
                this.request.setAttribute(name, value);
            }
        }

        @Override
        public Collection<String> getPropertyNames() {
            LinkedHashSet<String> list = new LinkedHashSet<String>();
            Enumeration attrNames = this.request.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String name = (String)attrNames.nextElement();
                if (ENDPOINT_ADDRESS_PROPERTY.equals(name)) continue;
                list.add(name);
            }
            list.addAll(super.getPropertyNames());
            return list;
        }
    }

    public static interface PropertyHolder {
        public Object getProperty(String var1);

        public void removeProperty(String var1);

        public void setProperty(String var1, Object var2);

        public Collection<String> getPropertyNames();
    }
}

