/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.AcceptorControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public class AcceptorControlImpl
extends AbstractControl
implements AcceptorControl {
    private final Acceptor acceptor;
    private final TransportConfiguration configuration;

    public AcceptorControlImpl(Acceptor acceptor, StorageManager storageManager, TransportConfiguration configuration) throws Exception {
        super(AcceptorControl.class, storageManager);
        this.acceptor = acceptor;
        this.configuration = configuration;
    }

    public String getFactoryClassName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getFactoryClassName((Object)this.acceptor);
        }
        this.clearIO();
        try {
            String string = this.configuration.getFactoryClassName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    public String getName() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getName((Object)this.acceptor);
        }
        this.clearIO();
        try {
            String string = this.configuration.getName();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getParameters() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.getParameters((Object)this.acceptor);
        }
        this.clearIO();
        try {
            HashMap clone = new HashMap(this.configuration.getCombinedParams());
            for (Map.Entry entry : clone.entrySet()) {
                if (!((String)entry.getKey()).toLowerCase().contains("password")) continue;
                entry.setValue("****");
            }
            HashMap hashMap = clone;
            return hashMap;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void reload() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.reload((Object)this.acceptor);
        }
        this.clearIO();
        try {
            this.acceptor.reload();
        }
        finally {
            this.blockOnIO();
        }
    }

    public boolean isStarted() {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.isStarted((Object)this.acceptor);
        }
        this.clearIO();
        try {
            boolean bl = this.acceptor.isStarted();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    public void start() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.startAcceptor((Object)this.acceptor);
        }
        this.clearIO();
        try {
            this.acceptor.start();
        }
        finally {
            this.blockOnIO();
        }
    }

    public void stop() throws Exception {
        if (AuditLogger.isBaseLoggingEnabled()) {
            AuditLogger.stopAcceptor((Object)this.acceptor);
        }
        this.clearIO();
        try {
            this.acceptor.stop();
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AcceptorControl.class);
    }

    @Override
    protected MBeanAttributeInfo[] fillMBeanAttributeInfo() {
        return MBeanInfoHelper.getMBeanAttributesInfo(AcceptorControl.class);
    }
}

