/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.settings.impl;

import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.utils.BufferHelper;

public class ResourceLimitSettings
implements Serializable,
EncodingSupport {
    private static final long serialVersionUID = -110638321333856932L;
    public static final SimpleString DEFAULT_MATCH = null;
    public static final Integer DEFAULT_MAX_SESSIONS = -1;
    public static final Integer DEFAULT_MAX_QUEUES = -1;
    SimpleString match = null;
    Integer maxSessions = null;
    Integer maxQueues = null;

    public void setName(String name) {
        this.setMatch(SimpleString.of((String)name));
    }

    public SimpleString getMatch() {
        return this.match != null ? this.match : DEFAULT_MATCH;
    }

    @Deprecated(forRemoval=true)
    public int getMaxConnections() {
        return this.getMaxSessions();
    }

    public int getMaxSessions() {
        return this.maxSessions != null ? this.maxSessions : DEFAULT_MAX_SESSIONS;
    }

    public int getMaxQueues() {
        return this.maxQueues != null ? this.maxQueues : DEFAULT_MAX_QUEUES;
    }

    public void setMatch(SimpleString match) {
        this.match = match;
    }

    @Deprecated(forRemoval=true)
    public void setMaxConnections(int maxConnections) {
        this.setMaxSessions(maxConnections);
    }

    public void setMaxSessions(int maxSessions) {
        this.maxSessions = maxSessions;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    public int getEncodeSize() {
        return SimpleString.sizeofNullableString((SimpleString)this.match) + BufferHelper.sizeOfNullableInteger((Integer)this.maxSessions) + BufferHelper.sizeOfNullableInteger((Integer)this.maxQueues);
    }

    public void encode(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.match);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxSessions);
        BufferHelper.writeNullableInteger((ActiveMQBuffer)buffer, (Integer)this.maxQueues);
    }

    public void decode(ActiveMQBuffer buffer) {
        this.match = buffer.readNullableSimpleString();
        this.maxSessions = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
        this.maxQueues = BufferHelper.readNullableInteger((ActiveMQBuffer)buffer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + (this.maxSessions == null ? 0 : this.maxSessions.hashCode());
        result = 31 * result + (this.maxQueues == null ? 0 : this.maxQueues.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceLimitSettings that = (ResourceLimitSettings)o;
        if (this.match != null ? !this.match.equals((Object)that.match) : that.match != null) {
            return false;
        }
        if (this.maxSessions != null ? !this.maxSessions.equals(that.maxSessions) : that.maxSessions != null) {
            return false;
        }
        return this.maxQueues != null ? this.maxQueues.equals(that.maxQueues) : that.maxQueues == null;
    }

    public String toString() {
        return "ResourceLimitSettings [match=" + this.match + ", maxSessions=" + this.maxSessions + ", maxQueues=" + this.maxQueues + "]";
    }
}

