/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResourceContextImpl;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ServerProviderFactory;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.invoker.AbstractInvoker;

public class JAXRSInvoker
extends AbstractInvoker {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSInvoker.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXRSInvoker.class);
    private static final String SERVICE_LOADER_AS_CONTEXT = "org.apache.cxf.serviceloader-context";
    private static final String SERVICE_OBJECT_SCOPE = "org.apache.cxf.service.scope";
    private static final String REQUEST_SCOPE = "request";
    private static final String LAST_SERVICE_OBJECT = "org.apache.cxf.service.object.last";
    private static final String PROXY_INVOCATION_ERROR_FRAGMENT = "object is not an instance of declaring class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object request) {
        MessageContentsList responseList = this.checkExchangeForResponse(exchange);
        if (responseList != null) {
            return responseList;
        }
        AsyncResponse asyncResp = (AsyncResponse)exchange.get(AsyncResponse.class);
        if (asyncResp != null) {
            AsyncResponseImpl asyncImpl = (AsyncResponseImpl)asyncResp;
            asyncImpl.prepareContinuation();
            try {
                asyncImpl.handleTimeout();
                return this.handleAsyncResponse(exchange, asyncImpl);
            }
            catch (Throwable t) {
                return this.handleAsyncFault(exchange, asyncImpl, t);
            }
        }
        ResourceProvider provider = this.getResourceProvider(exchange);
        Object rootInstance = null;
        Message inMessage = exchange.getInMessage();
        try {
            rootInstance = this.getServiceObject(exchange);
            Object serviceObject = this.getActualServiceObject(exchange, rootInstance);
            Object object = this.invoke(exchange, request, serviceObject);
            return object;
        }
        catch (WebApplicationException ex) {
            responseList = this.checkExchangeForResponse(exchange);
            if (responseList != null) {
                MessageContentsList messageContentsList = responseList;
                return messageContentsList;
            }
            Object object = this.handleFault(ex, inMessage);
            return object;
        }
        finally {
            boolean suspended = this.isSuspended(exchange);
            if (suspended || exchange.isOneWay() || inMessage.get((Object)"thread.context.switched") != null) {
                ServerProviderFactory.clearThreadLocalProxies(inMessage);
            }
            if (suspended || this.isServiceObjectRequestScope(inMessage)) {
                this.persistRoots(exchange, rootInstance, provider);
            } else {
                provider.releaseInstance(inMessage, rootInstance);
            }
        }
    }

    private boolean isSuspended(Exchange exchange) {
        return exchange.getInMessage().getInterceptorChain().getState() == InterceptorChain.State.SUSPENDED;
    }

    private Object handleAsyncResponse(Exchange exchange, AsyncResponseImpl ar) {
        Object asyncObj = ar.getResponseObject();
        if (asyncObj instanceof Throwable) {
            Throwable throwable;
            Throwable cause = throwable = (Throwable)asyncObj;
            if (throwable instanceof CompletionException) {
                cause = throwable.getCause();
            }
            return this.handleAsyncFault(exchange, ar, cause != null ? cause : throwable);
        }
        this.setResponseContentTypeIfNeeded(exchange.getInMessage(), asyncObj);
        return new MessageContentsList(new Object[]{asyncObj});
    }

    private Object handleAsyncFault(Exchange exchange, AsyncResponseImpl ar, Throwable t) {
        try {
            return this.handleFault(new Fault(t), exchange.getInMessage(), null, null);
        }
        catch (Fault ex) {
            ar.setUnmappedThrowable(ex.getCause() == null ? ex : ex.getCause());
            if (this.isSuspended(exchange)) {
                ar.reset();
                exchange.getInMessage().getInterceptorChain().unpause();
            }
            return new MessageContentsList(new Object[]{Response.serverError().build()});
        }
    }

    private void persistRoots(Exchange exchange, Object rootInstance, Object provider) {
        exchange.put((Object)"service.root.instance", rootInstance);
        exchange.put((Object)"service.root.provider", provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        ApplicationInfo appProvider;
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        Message inMessage = exchange.getInMessage();
        ServerProviderFactory providerFactory = ServerProviderFactory.getInstance(inMessage);
        cri.injectContexts(resourceObject, ori, inMessage);
        if (cri.isRoot() && (appProvider = providerFactory.getApplicationProvider()) != null) {
            InjectionUtils.injectContexts(appProvider.getProvider(), appProvider, inMessage);
        }
        Method methodToInvoke = this.getMethodToInvoke(cri, ori, resourceObject);
        List params = null;
        if (request instanceof List) {
            params = CastUtils.cast((List)((List)request));
        } else if (request != null) {
            params = new MessageContentsList(new Object[]{request});
        }
        Object result = null;
        ClassLoaderUtils.ClassLoaderHolder contextLoader = null;
        AsyncResponseImpl asyncResponse = null;
        try {
            if (this.setServiceLoaderAsContextLoader(inMessage)) {
                contextLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)resourceObject.getClass().getClassLoader());
            }
            if (!ori.isSubResourceLocator()) {
                asyncResponse = (AsyncResponseImpl)inMessage.get(AsyncResponse.class);
            }
            result = this.invoke(exchange, resourceObject, methodToInvoke, params);
            if (asyncResponse == null && !ori.isSubResourceLocator()) {
                asyncResponse = this.checkFutureResponse(inMessage, JAXRSInvoker.checkResultObject(result));
            }
            if (asyncResponse != null) {
                if (!asyncResponse.suspendContinuationIfNeeded()) {
                    result = this.handleAsyncResponse(exchange, asyncResponse);
                } else {
                    providerFactory.clearThreadLocalProxies();
                }
            }
        }
        catch (Fault ex) {
            Object faultResponse = asyncResponse != null ? this.handleAsyncFault(exchange, asyncResponse, ex.getCause() == null ? ex : ex.getCause()) : this.handleFault(ex, inMessage, cri, methodToInvoke);
            Object object = faultResponse;
            return object;
        }
        finally {
            exchange.put((Object)LAST_SERVICE_OBJECT, resourceObject);
            if (contextLoader != null) {
                contextLoader.reset();
            }
        }
        ClassResourceInfo subCri = null;
        if (ori.isSubResourceLocator()) {
            try {
                Class<?> subResponseType;
                MultivaluedMap<String, String> values = this.getTemplateValues(inMessage);
                String subResourcePath = (String)values.getFirst((Object)"FINAL_MATCH_GROUP");
                String httpMethod = (String)inMessage.get((Object)"org.apache.cxf.request.method");
                String contentType = (String)inMessage.get((Object)"Content-Type");
                if (contentType == null) {
                    contentType = "*/*";
                }
                List acceptContentType = (List)exchange.get((Object)"Accept");
                if ((result = JAXRSInvoker.checkSubResultObject(result, subResourcePath)).getClass() == Class.class) {
                    ResourceContextImpl rc = new ResourceContextImpl(inMessage, ori);
                    result = rc.getResource((Class)result);
                    subResponseType = InjectionUtils.getActualType(methodToInvoke.getGenericReturnType());
                } else {
                    subResponseType = methodToInvoke.getReturnType();
                }
                subCri = cri.getSubResource(subResponseType, ClassHelper.getRealClass((Bus)exchange.getBus(), (Object)result), result);
                if (subCri == null) {
                    org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NO_SUBRESOURCE_FOUND", BUNDLE, new Object[]{subResourcePath});
                    LOG.severe(errorM.toString());
                    throw ExceptionUtils.toNotFoundException(null, null);
                }
                OperationResourceInfo subOri = JAXRSUtils.findTargetMethod(Collections.singletonMap(subCri, values), inMessage, httpMethod, values, contentType, acceptContentType);
                exchange.put(OperationResourceInfo.class, (Object)subOri);
                inMessage.put((Object)"jaxrs.template.parameters", values);
                inMessage.put((Object)"jaxrs.template.uri", (Object)JAXRSUtils.getUriTemplate(inMessage, subCri, ori, subOri));
                if (!subOri.isSubResourceLocator() && JAXRSUtils.runContainerRequestFilters(providerFactory, inMessage, false, subOri.getNameBindings())) {
                    return new MessageContentsList(new Object[]{exchange.get(Response.class)});
                }
                List<Object> newParams = JAXRSUtils.processParameters(subOri, values, inMessage);
                inMessage.setContent(List.class, newParams);
                return this.invoke(exchange, newParams, result);
            }
            catch (IOException ex) {
                Response resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                if (resp == null) {
                    resp = JAXRSUtils.convertFaultToResponse(ex, inMessage);
                }
                return new MessageContentsList(new Object[]{resp});
            }
            catch (WebApplicationException ex) {
                Response excResponse = JAXRSUtils.noResourceMethodForOptions(ex.getResponse(), (String)inMessage.get((Object)"org.apache.cxf.request.method")) ? JAXRSUtils.createResponse(Collections.singletonList(subCri), null, null, 200, true) : JAXRSUtils.convertFaultToResponse(ex, inMessage);
                return new MessageContentsList(new Object[]{excResponse});
            }
        }
        this.setResponseContentTypeIfNeeded(inMessage, result);
        return result;
    }

    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (result instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)result;
            AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
            stage.whenComplete((v, t) -> {
                if (t instanceof CancellationException) {
                    asyncResponse.cancel();
                } else {
                    asyncResponse.resume(v != null ? v : t);
                }
            });
            return asyncResponse;
        }
        return null;
    }

    protected Method getMethodToInvoke(ClassResourceInfo cri, OperationResourceInfo ori, Object resourceObject) {
        Method methodToInvoke;
        Method resourceMethod = cri.getMethodDispatcher().getMethod(ori);
        if (Proxy.class.isInstance(resourceObject)) {
            methodToInvoke = cri.getMethodDispatcher().getProxyMethod(resourceMethod);
            if (methodToInvoke == null) {
                methodToInvoke = InjectionUtils.checkProxy(resourceMethod, resourceObject);
                cri.getMethodDispatcher().addProxyMethod(resourceMethod, methodToInvoke);
            }
        } else {
            methodToInvoke = resourceMethod;
        }
        return methodToInvoke;
    }

    private MessageContentsList checkExchangeForResponse(Exchange exchange) {
        Response r = (Response)exchange.get(Response.class);
        if (r != null) {
            JAXRSUtils.setMessageContentType(exchange.getInMessage(), r);
            return new MessageContentsList(new Object[]{r});
        }
        return null;
    }

    private void setResponseContentTypeIfNeeded(Message inMessage, Object response) {
        if (response instanceof Response) {
            JAXRSUtils.setMessageContentType(inMessage, (Response)response);
        }
    }

    private Object handleFault(Throwable ex, Message inMessage) {
        return this.handleFault(new Fault(ex), inMessage, null, null);
    }

    private Object handleFault(Fault ex, Message inMessage, ClassResourceInfo cri, Method methodToInvoke) {
        Response excResponse;
        String errorMessage = ex.getMessage();
        if (errorMessage != null && cri != null && errorMessage.contains(PROXY_INVOCATION_ERROR_FRAGMENT)) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("PROXY_INVOCATION_FAILURE", BUNDLE, new Object[]{methodToInvoke, cri.getServiceClass().getName()});
            LOG.severe(errorM.toString());
        }
        if ((excResponse = JAXRSUtils.convertFaultToResponse(ex.getCause() == null ? ex : ex.getCause(), inMessage)) == null) {
            inMessage.getExchange().put((Object)Message.PROPOGATE_EXCEPTION, (Object)ExceptionUtils.propogateException(inMessage));
            throw ex;
        }
        return new MessageContentsList(new Object[]{excResponse});
    }

    protected MultivaluedMap<String, String> getTemplateValues(Message msg) {
        MetadataMap<String, String> values = new MetadataMap<String, String>();
        MultivaluedMap oldValues = (MultivaluedMap)msg.get((Object)"jaxrs.template.parameters");
        if (oldValues != null) {
            values.putAll((Map)oldValues);
        }
        return values;
    }

    private boolean setServiceLoaderAsContextLoader(Message inMessage) {
        Object en = inMessage.getContextualProperty(SERVICE_LOADER_AS_CONTEXT);
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    private boolean isServiceObjectRequestScope(Message inMessage) {
        Object scope = inMessage.getContextualProperty(SERVICE_OBJECT_SCOPE);
        return REQUEST_SCOPE.equals(scope);
    }

    private ResourceProvider getResourceProvider(Exchange exchange) {
        Object provider = exchange.remove((Object)"service.root.provider");
        if (provider == null) {
            OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
            ClassResourceInfo cri = ori.getClassResourceInfo();
            return cri.getResourceProvider();
        }
        return (ResourceProvider)provider;
    }

    public Object getServiceObject(Exchange exchange) {
        Object root = exchange.remove((Object)"service.root.instance");
        if (root != null) {
            return root;
        }
        OperationResourceInfo ori = (OperationResourceInfo)exchange.get(OperationResourceInfo.class);
        ClassResourceInfo cri = ori.getClassResourceInfo();
        return cri.getResourceProvider().getInstance(exchange.getInMessage());
    }

    protected Object getActualServiceObject(Exchange exchange, Object rootInstance) {
        Object last = exchange.get((Object)LAST_SERVICE_OBJECT);
        return last != null ? last : rootInstance;
    }

    private static Object checkResultObject(Object result) {
        if (result != null) {
            if (result instanceof MessageContentsList) {
                result = ((MessageContentsList)result).get(0);
            } else if (result instanceof List) {
                result = ((List)result).get(0);
            } else if (result.getClass().isArray()) {
                result = ((Object[])result)[0];
            }
        }
        return result;
    }

    private static Object checkSubResultObject(Object result, String subResourcePath) {
        if ((result = JAXRSInvoker.checkResultObject(result)) == null) {
            org.apache.cxf.common.i18n.Message errorM = new org.apache.cxf.common.i18n.Message("NULL_SUBRESOURCE", BUNDLE, new Object[]{subResourcePath});
            LOG.info(errorM.toString());
            throw ExceptionUtils.toNotFoundException(null, null);
        }
        return result;
    }
}

