/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionProvider;

public class AesCbcHmacJweDecryption
extends JweDecryption {
    private final String supportedAlgo;

    public AesCbcHmacJweDecryption(KeyDecryptionProvider keyDecryptionAlgo) {
        this(keyDecryptionAlgo, (ContentAlgorithm)null);
    }

    public AesCbcHmacJweDecryption(KeyDecryptionProvider keyDecryptionAlgo, ContentAlgorithm supportedAlgo) {
        super(keyDecryptionAlgo, new AesCbcContentDecryptionAlgorithm(supportedAlgo));
        this.supportedAlgo = supportedAlgo == null ? null : supportedAlgo.getJwaName();
    }

    @Override
    protected JweDecryptionOutput doDecrypt(JweDecryptionInput jweDecryptionInput, byte[] cek) {
        this.validateAuthenticationTag(jweDecryptionInput, cek);
        return super.doDecrypt(jweDecryptionInput, cek);
    }

    @Override
    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        this.validateCekAlgorithm(algoJwt);
        return AesCbcHmacJweEncryption.doGetActualCek(theCek, algoJwt);
    }

    protected void validateAuthenticationTag(JweDecryptionInput jweDecryptionInput, byte[] theCek) {
        byte[] actualAuthTag = jweDecryptionInput.getAuthTag();
        AesCbcHmacJweEncryption.MacState macState = AesCbcHmacJweEncryption.getInitializedMacState(theCek, jweDecryptionInput.getInitVector(), jweDecryptionInput.getAad(), jweDecryptionInput.getJweHeaders(), jweDecryptionInput.getDecodedJsonHeaders());
        macState.mac.update(jweDecryptionInput.getEncryptedContent());
        byte[] expectedAuthTag = AesCbcHmacJweEncryption.signAndGetTag(macState);
        if (!MessageDigest.isEqual(actualAuthTag, expectedAuthTag)) {
            LOG.warning("Invalid authentication tag");
            throw new JweException(JweException.Error.CONTENT_DECRYPTION_FAILURE);
        }
    }

    private String validateCekAlgorithm(String cekAlgo) {
        if (!AlgorithmUtils.isAesCbcHmac(cekAlgo) || this.supportedAlgo != null && !this.supportedAlgo.equals(cekAlgo)) {
            LOG.warning("Invalid content encryption algorithm");
            throw new JweException(JweException.Error.INVALID_CONTENT_ALGORITHM);
        }
        return cekAlgo;
    }

    private static class AesCbcContentDecryptionAlgorithm
    extends AbstractContentEncryptionCipherProperties
    implements ContentDecryptionProvider {
        AesCbcContentDecryptionAlgorithm(ContentAlgorithm supportedAlgo) {
            super(supportedAlgo);
        }

        @Override
        public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
            return new IvParameterSpec(theIv);
        }

        @Override
        public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
            return null;
        }

        @Override
        public byte[] getEncryptedSequence(JweHeaders headers, byte[] cipher, byte[] authTag) {
            return cipher;
        }
    }
}

