/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.CoreServiceConfigurationParser;
import org.ehcache.xml.XmlUtil;
import org.ehcache.xml.model.CacheTemplate;
import org.ehcache.xml.model.CacheType;
import org.ehcache.xml.service.DefaultCacheEventDispatcherConfigurationParser;
import org.ehcache.xml.service.DefaultCacheEventListenerConfigurationParser;
import org.ehcache.xml.service.DefaultCacheLoaderWriterConfigurationParser;
import org.ehcache.xml.service.DefaultCopierConfigurationParser;
import org.ehcache.xml.service.DefaultResilienceStrategyConfigurationParser;
import org.ehcache.xml.service.DefaultSerializerConfigurationParser;
import org.ehcache.xml.service.DefaultSizeOfEngineConfigurationParser;
import org.ehcache.xml.service.DefaultWriteBehindConfigurationParser;
import org.ehcache.xml.service.OffHeapDiskStoreConfigurationParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceConfigurationParser {
    static final Collection<CoreServiceConfigurationParser<CacheTemplate, CacheType>> CORE_SERVICE_CONFIGURATION_PARSERS = Arrays.asList(new DefaultSerializerConfigurationParser(), new DefaultCopierConfigurationParser(), new DefaultCacheLoaderWriterConfigurationParser(), new DefaultResilienceStrategyConfigurationParser(), new DefaultSizeOfEngineConfigurationParser(), new DefaultWriteBehindConfigurationParser(), new OffHeapDiskStoreConfigurationParser(), new DefaultCacheEventDispatcherConfigurationParser(), new DefaultCacheEventListenerConfigurationParser());
    private final Map<Class<?>, CacheServiceConfigurationParser<?, ?>> extensionParsers;

    public ServiceConfigurationParser(Map<Class<?>, CacheServiceConfigurationParser<?, ?>> extensionParsers) {
        this.extensionParsers = extensionParsers;
    }

    public <K, V> CacheConfigurationBuilder<K, V> parse(Document document, CacheTemplate cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        for (CoreServiceConfigurationParser<CacheTemplate, CacheType> coreServiceConfigParser : CORE_SERVICE_CONFIGURATION_PARSERS) {
            cacheBuilder = coreServiceConfigParser.parseServiceConfiguration(cacheDefinition, cacheClassLoader, cacheBuilder);
        }
        Map<URI, CacheServiceConfigurationParser> parsers = this.extensionParsers.values().stream().flatMap(parser -> parser.getTargetNamespaces().stream().map(ns -> new AbstractMap.SimpleImmutableEntry<URI, CacheServiceConfigurationParser>((URI)ns, (CacheServiceConfigurationParser)parser))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Element element : cacheDefinition.serviceConfigExtensions()) {
            Element typedElement = (Element)XmlUtil.findMatchingNodeInDocument(document, element).cloneNode(true);
            URI namespace = URI.create(typedElement.getNamespaceURI());
            CacheServiceConfigurationParser xmlConfigurationParser = parsers.get(namespace);
            if (xmlConfigurationParser == null) {
                throw new IllegalArgumentException("Can't find parser for namespace: " + namespace);
            }
            cacheBuilder = cacheBuilder.withService((ServiceConfiguration)xmlConfigurationParser.parse(typedElement, cacheClassLoader));
        }
        return cacheBuilder;
    }

    CacheType unparse(Document target, CacheConfiguration<?, ?> cacheConfiguration, CacheType cacheType) {
        for (CoreServiceConfigurationParser<CacheTemplate, CacheType> parser : CORE_SERVICE_CONFIGURATION_PARSERS) {
            parser.unparseServiceConfiguration(cacheConfiguration, cacheType);
        }
        List<Element> serviceConfigs = cacheType.getServiceConfiguration();
        cacheConfiguration.getServiceConfigurations().forEach(config -> {
            CacheServiceConfigurationParser<?, ?> parser = this.extensionParsers.get(config.getServiceType());
            if (parser != null) {
                Element element = parser.unparse(target, config);
                serviceConfigs.add(element);
            }
        });
        return cacheType;
    }
}

