/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;

public class ClientTLSValidationConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<ClientTLSValidationConfiguration> configs;

    public ClientTLSValidationConfigurationCriterion(@Nonnull @NotEmpty List<ClientTLSValidationConfiguration> configurations) {
        this.configs = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    public ClientTLSValidationConfigurationCriterion(ClientTLSValidationConfiguration ... configurations) {
        this.configs = CollectionSupport.listOf((Object[])((ClientTLSValidationConfiguration[])Constraint.isNotNull((Object)configurations, (String)"List of configurations cannot be null")));
        Constraint.isNotEmpty(this.configs, (String)"At least one configuration is required");
    }

    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    public List<ClientTLSValidationConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClientTLSValidationConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ClientTLSValidationConfigurationCriterion) {
            ClientTLSValidationConfigurationCriterion other = (ClientTLSValidationConfigurationCriterion)obj;
            return this.configs.equals(other.getConfigurations());
        }
        return false;
    }
}

