/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.utils.actors.ArtemisExecutor;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;

public class LastValueQueue
extends QueueImpl {
    private final Map<SimpleString, MessageReference> map = new ConcurrentHashMap<SimpleString, MessageReference>();

    public LastValueQueue(QueueConfiguration queueConfiguration, Filter filter, PagingStore pagingStore, PageSubscription pageSubscription, ScheduledExecutorService scheduledExecutor, PostOffice postOffice, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository, ArtemisExecutor executor, ActiveMQServer server, QueueFactory factory) {
        super(queueConfiguration, filter, pagingStore, pageSubscription, scheduledExecutor, postOffice, storageManager, addressSettingsRepository, executor, server, factory);
    }

    @Override
    public synchronized void addTail(MessageReference ref, boolean direct) {
        if (!this.scheduleIfPossible(ref)) {
            this.trackLastValue(ref);
            super.addTail(ref, this.isNonDestructive() ? false : direct);
        }
    }

    @Override
    public void addHead(MessageReference ref, boolean scheduling) {
        if (scheduling) {
            this.trackLastValue(ref);
        } else if (!this.isNonDestructive()) {
            this.trackLastValueIfAbsent(ref);
        }
        super.addHead(ref, scheduling);
    }

    @Override
    public void addSorted(MessageReference ref, boolean scheduling) {
        this.addHead(ref, scheduling);
    }

    private void trackLastValue(MessageReference ref) {
        SimpleString lastValueProperty = ref.getLastValueProperty();
        if (lastValueProperty != null) {
            this.map.put(lastValueProperty, ref);
        }
    }

    private void trackLastValueIfAbsent(MessageReference ref) {
        SimpleString lastValueProperty = ref.getLastValueProperty();
        if (lastValueProperty != null) {
            this.map.putIfAbsent(lastValueProperty, ref);
        }
    }

    @Override
    public long getMessageCount() {
        return super.getMessageCount() - (long)this.getDeliveringCount();
    }

    @Override
    public boolean allowsReferenceCallback() {
        return false;
    }

    @Override
    protected void pruneLastValues() {
        block10: {
            LinkedListIterator iter = this.messageReferences.iterator();
            block7: while (true) {
                while (iter.hasNext()) {
                    MessageReference ref = (MessageReference)iter.next();
                    if (this.currentLastValue(ref)) continue;
                    iter.remove();
                    try {
                        this.referenceHandled(ref);
                        super.refRemoved(ref);
                        ref.acknowledge(null, AckReason.REPLACED, null);
                        continue block7;
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorAckingOldReference(e);
                    }
                }
                break block10;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (iter != null) {
                    iter.close();
                }
            }
        }
    }

    private boolean currentLastValue(MessageReference ref) {
        boolean currentLastValue = false;
        SimpleString lastValueProp = ref.getLastValueProperty();
        if (lastValueProp != null) {
            MessageReference current = this.map.get(lastValueProp);
            if (current == ref) {
                currentLastValue = true;
            }
        } else {
            return true;
        }
        return currentLastValue;
    }

    @Override
    protected void refRemoved(MessageReference ref) {
        this.removeIfCurrent(ref);
        super.refRemoved(ref);
    }

    @Override
    public void acknowledge(MessageReference ref, AckReason reason, ServerConsumer consumer) throws Exception {
        if (reason == AckReason.EXPIRED || reason == AckReason.KILLED) {
            this.removeIfCurrent(ref);
        }
        super.acknowledge(ref, reason, consumer);
    }

    @Override
    public void acknowledge(Transaction tx, MessageReference ref, AckReason reason, ServerConsumer consumer, boolean delivering) throws Exception {
        if (reason == AckReason.EXPIRED || reason == AckReason.KILLED) {
            this.removeIfCurrent(ref);
        }
        super.acknowledge(tx, ref, reason, consumer, delivering);
    }

    @Override
    public synchronized void reload(MessageReference newRef) {
        this.trackLastValue(newRef);
        super.reload(newRef);
    }

    private synchronized void removeIfCurrent(MessageReference ref) {
        MessageReference current;
        SimpleString lastValueProp = ref.getLastValueProperty();
        if (lastValueProp != null && (current = this.map.get(lastValueProp)) == ref) {
            this.map.remove(lastValueProp);
        }
    }

    @Override
    QueueImpl.QueueIterateAction createDeleteMatchingAction(AckReason ackReason) {
        final QueueImpl.QueueIterateAction queueIterateAction = super.createDeleteMatchingAction(ackReason);
        return new QueueImpl.QueueIterateAction(){

            @Override
            public boolean actMessage(Transaction tx, MessageReference ref) throws Exception {
                LastValueQueue.this.removeIfCurrent(ref);
                return queueIterateAction.actMessage(tx, ref);
            }
        };
    }

    public synchronized Set<SimpleString> getLastValueKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.map);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LastValueQueue)) {
            return false;
        }
        LastValueQueue other = (LastValueQueue)obj;
        return Objects.equals(this.map, other.map);
    }
}

