/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.impl.LastValueQueue;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;

public class QueueFactoryImpl
implements QueueFactory {
    protected final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    protected final ScheduledExecutorService scheduledExecutor;
    protected PostOffice postOffice;
    protected final StorageManager storageManager;
    protected final ExecutorFactory executorFactory;
    protected final ActiveMQServer server;

    public QueueFactoryImpl(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, HierarchicalRepository<AddressSettings> addressSettingsRepository, StorageManager storageManager, ActiveMQServer server) {
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
        this.server = server;
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @Override
    public Queue createQueueWith(QueueConfiguration config, PagingManager pagingManager, Filter filter) {
        this.validateState(config);
        PageSubscription pageSubscription = QueueFactoryImpl.getPageSubscription(config, pagingManager, filter);
        QueueImpl queue = QueueFactoryImpl.lastValueKey(config) != null ? new LastValueQueue(config.setLastValueKey(QueueFactoryImpl.lastValueKey(config)), filter, pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this) : new QueueImpl(config, filter, pageSubscription != null ? pageSubscription.getPagingStore() : null, pageSubscription, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor(), this.server, this);
        this.server.getCriticalAnalyzer().add((CriticalComponent)queue);
        return queue;
    }

    @Override
    public void queueRemoved(Queue queue) {
        this.server.getCriticalAnalyzer().remove((CriticalComponent)queue);
    }

    public static PageSubscription getPageSubscription(QueueConfiguration queueConfiguration, PagingManager pagingManager, Filter filter) {
        PageSubscription pageSubscription;
        try {
            PagingStore pageStore = pagingManager.getPageStore(queueConfiguration.getAddress());
            pageSubscription = pageStore != null ? pageStore.getCursorProvider().createSubscription(queueConfiguration.getId(), filter, queueConfiguration.isDurable()) : null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return pageSubscription;
    }

    private static SimpleString lastValueKey(QueueConfiguration config) {
        if (config.getLastValueKey() != null && !config.getLastValueKey().isEmpty()) {
            return config.getLastValueKey();
        }
        if (config.isLastValue().booleanValue()) {
            return Message.HDR_LAST_VALUE_NAME;
        }
        return null;
    }

    private void validateState(QueueConfiguration config) {
        if (QueueFactoryImpl.isEmptyOrNull(config.getName())) {
            throw new IllegalStateException("name can't be null or empty!");
        }
        if (QueueFactoryImpl.isEmptyOrNull(config.getAddress())) {
            throw new IllegalStateException("address can't be null or empty!");
        }
    }

    private static boolean isEmptyOrNull(SimpleString value) {
        return value == null || value.isEmpty();
    }
}

