/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.thetacommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.thetacommon.BoundsOnRatiosInTupleSketchedSets;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleIntersection;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketch;
import org.apache.datasketches.tuple.UpdatableTupleSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryFactory;
import org.apache.datasketches.tuple.adouble.DoubleSummarySetOperations;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BoundsOnRatiosInTupleSketchedSetsTest {
    private final DoubleSummary.Mode umode = DoubleSummary.Mode.Sum;
    private final DoubleSummarySetOperations dsso = new DoubleSummarySetOperations();
    private final DoubleSummaryFactory factory = new DoubleSummaryFactory(this.umode);
    private final UpdatableThetaSketchBuilder thetaBldr = UpdatableThetaSketch.builder();
    private final UpdatableTupleSketchBuilder<Double, DoubleSummary> tupleBldr = new UpdatableTupleSketchBuilder((SummaryFactory)this.factory);
    private final Double constSummary = 1.0;

    @Test
    public void checkNormalReturns1() {
        int i;
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableTupleSketch skC = this.tupleBldr.build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000), (Object)this.constSummary);
        }
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso);
        inter.intersect((TupleSketch)skA);
        inter.intersect((TupleSketch)skC);
        CompactTupleSketch skB = inter.getResult();
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skB);
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skB);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skC);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (TupleSketch)skC);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (TupleSketch)skC);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
    }

    @Test
    public void checkNormalReturns2() {
        int i;
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableThetaSketch skC = this.thetaBldr.build();
        int uA = 10000;
        int uC = 100000;
        for (i = 0; i < 10000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 100000; ++i) {
            skC.update((long)(i + 5000));
        }
        TupleIntersection inter = new TupleIntersection((SummarySetOperations)this.dsso);
        inter.intersect((TupleSketch)skA);
        inter.intersect((ThetaSketch)skC, (Summary)this.factory.newSummary());
        CompactTupleSketch skB = inter.getResult();
        double est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skB);
        double lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        double ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        Assert.assertTrue((ub > est ? 1 : 0) != 0);
        Assert.assertTrue((est > lb ? 1 : 0) != 0);
        Assert.assertEquals((double)est, (double)0.5, (double)0.03);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skA.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skB);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (TupleSketch)skB);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
        skC.reset();
        est = BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (ThetaSketch)skC);
        lb = BoundsOnRatiosInTupleSketchedSets.getLowerBoundForBoverA((TupleSketch)skA, (ThetaSketch)skC);
        ub = BoundsOnRatiosInTupleSketchedSets.getUpperBoundForBoverA((TupleSketch)skA, (ThetaSketch)skC);
        BoundsOnRatiosInTupleSketchedSetsTest.println("ub : " + ub);
        BoundsOnRatiosInTupleSketchedSetsTest.println("est: " + est);
        BoundsOnRatiosInTupleSketchedSetsTest.println("lb : " + lb);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns1() {
        int i;
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableTupleSketch skC = this.tupleBldr.build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000), (Object)this.constSummary);
        }
        BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (TupleSketch)skC);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkAbnormalReturns2() {
        int i;
        UpdatableTupleSketch skA = this.tupleBldr.build();
        UpdatableThetaSketch skC = this.thetaBldr.build();
        int uA = 100000;
        int uC = 10000;
        for (i = 0; i < 100000; ++i) {
            skA.update((long)i, (Object)this.constSummary);
        }
        for (i = 0; i < 10000; ++i) {
            skC.update((long)(i + 50000));
        }
        BoundsOnRatiosInTupleSketchedSets.getEstimateOfBoverA((TupleSketch)skA, (ThetaSketch)skC);
    }

    @Test
    public void printlnTest() {
        BoundsOnRatiosInTupleSketchedSetsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

