/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

final class Util {
    static final TupleFactory tupleFactory = TupleFactory.getInstance();

    Util() {
    }

    static Tuple doubleArrayToTuple(double[] array) throws ExecException {
        Tuple tuple = tupleFactory.newTuple(array.length);
        for (int i = 0; i < array.length; ++i) {
            tuple.set(i, (Object)array[i]);
        }
        return tuple;
    }

    static <S extends Summary> Sketch<S> deserializeSketchFromTuple(Tuple tuple, SummaryDeserializer<S> summaryDeserializer) throws ExecException {
        byte[] bytes = ((DataByteArray)tuple.get(0)).get();
        return Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), summaryDeserializer);
    }
}

