/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.util.Arrays;
import java.util.Random;

public class SampMog {
    public Random rng;
    public static final int max_n = 6;
    int n = 3;
    final double[] weight = new double[6];
    final double[] mean = new double[6];
    final double[] var = new double[6];
    final double[] cumulative = new double[6];
    final double[] stdv = new double[6];

    public SampMog() {
        this.rng = new Random(System.currentTimeMillis());
    }

    public SampMog(Random random) {
        this.rng = random;
    }

    public void generate(int n, double[] dArray) {
        double d;
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = d = this.rng.nextGaussian();
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d2;
            d = this.rng.nextDouble();
            int n3 = Arrays.binarySearch(this.cumulative, d);
            if (n3 < 0) {
                n3 = -(n3 + 1);
            }
            if (n3 >= this.n) {
                n3 = this.n - 1;
            }
            double d3 = this.mean[n3];
            double d4 = this.stdv[n3];
            double d5 = dArray[n2];
            dArray[n2] = d2 = d3 + d4 * d5;
        }
    }

    public static int getMaxNumber() {
        return 6;
    }

    public int getNumber() {
        return this.n;
    }

    public void set(int n, double[] dArray, double[] dArray2, double[] dArray3) {
        this.setNumber(n);
        this.setWeights(dArray);
        this.setMeans(dArray2);
        this.setVars(dArray3);
    }

    public void setNumber(int n) {
        if (1 > n || n > 6) {
            String string = "Number of Gaussian components (" + n + ") not in [1, 6].";
            throw new IllegalArgumentException(string);
        }
        this.n = n;
    }

    public void setWeights(double[] dArray) {
        int n;
        int n2;
        System.arraycopy(dArray, 0, this.weight, 0, this.n);
        IllegalArgumentException illegalArgumentException = null;
        double d = 0.0;
        for (n2 = 0; n2 < this.n; ++n2) {
            double d2 = this.weight[n2];
            if (d2 > 0.0) {
                d += d2;
                continue;
            }
            if (illegalArgumentException != null) continue;
            String string = "Invalid weight (" + d2 + ").";
            illegalArgumentException = new IllegalArgumentException(string);
        }
        if (d > 0.0) {
            n2 = 0;
            while (n2 < this.n) {
                int n3 = n2++;
                this.weight[n3] = this.weight[n3] / d;
            }
        } else if (illegalArgumentException == null) {
            String string = "Invalid total weight (" + d + ").";
            illegalArgumentException = new IllegalArgumentException(string);
        }
        if (illegalArgumentException != null) {
            throw illegalArgumentException;
        }
        this.cumulative[0] = this.weight[0];
        for (n = 1; n < this.n; ++n) {
            this.cumulative[n] = Math.min(this.cumulative[n - 1] + this.weight[n], 1.0);
        }
        for (n = this.n; n < 6; ++n) {
            this.cumulative[n] = 1.0;
        }
    }

    public void setMeans(double[] dArray) {
        System.arraycopy(dArray, 0, this.mean, 0, this.n);
    }

    public void setVars(double[] dArray) {
        for (int i = 0; i < this.n; ++i) {
            double d;
            this.var[i] = d = Math.abs(dArray[i]);
            this.stdv[i] = Math.sqrt(d);
        }
    }
}

