/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.panel;

import com.inmethod.grid.column.PropertyColumn;
import com.inmethod.grid.treegrid.TreeGrid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.web.control.SecUtils;
import org.apache.directory.fortress.web.event.SaveModelEvent;
import org.apache.directory.fortress.web.modal.ModalWindow;
import org.apache.directory.fortress.web.model.ObjectListModel;
import org.apache.directory.fortress.web.panel.OUSearchModalPanel;
import org.apache.directory.fortress.web.panel.ObjectListPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectListPanel
extends FormComponentPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectListPanel.class.getName());
    private Form listForm;
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode node;
    private TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid;
    private DefaultMutableTreeNode rootNode;
    private TextField searchValFld;
    private RadioGroup radioGroup;
    private String searchVal;
    private char selectedRadioButton;
    private static final char NAMES = 'N';
    private static final char OUS = 'O';

    public ObjectListPanel(String id, boolean isAdmin) {
        super(id);
        ObjectListModel objectListModel = new ObjectListModel(new PermObj(""), isAdmin, SecUtils.getSession((Component)this));
        this.setDefaultModel((IModel)objectListModel);
        this.addGrid();
        this.radioGroup = new RadioGroup("searchOptions", (IModel)new PropertyModel((Object)this, "selectedRadioButton"));
        this.add(new Component[]{this.radioGroup});
        Radio objectRb = new Radio("objectRb", (IModel)new Model((Serializable)Character.valueOf('N')));
        this.radioGroup.add(new Component[]{objectRb});
        Radio ouRb = new Radio("ouRb", (IModel)new Model((Serializable)Character.valueOf('O')));
        this.radioGroup.add(new Component[]{ouRb});
        this.addOUSearchModal(ouRb);
        this.radioGroup.setOutputMarkupId(true);
        this.radioGroup.setRenderBodyOnly(false);
        this.searchValFld = new TextField("searchVal", (IModel)new PropertyModel((Object)this, "searchVal"));
        this.searchValFld.setOutputMarkupId(true);
        1 ajaxUpdater = new /* Unavailable Anonymous Inner Class!! */;
        this.searchValFld.add(new Behavior[]{ajaxUpdater});
        this.radioGroup.add(new Component[]{this.searchValFld});
        this.listForm.add(new Component[]{this.radioGroup});
        this.selectedRadioButton = (char)78;
        this.listForm.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    public void onEvent(IEvent event) {
        if (event.getPayload() instanceof SaveModelEvent) {
            SaveModelEvent modelEvent = (SaveModelEvent)event.getPayload();
            switch (6.$SwitchMap$org$apache$directory$fortress$web$event$SaveModelEvent$Operations[modelEvent.getOperation().ordinal()]) {
                case 1: {
                    this.add(modelEvent.getEntity());
                    break;
                }
                case 2: {
                    this.modelChanged();
                    break;
                }
                case 3: {
                    this.prune();
                    break;
                }
                default: {
                    LOG.error("onEvent caught invalid operation");
                }
            }
            AjaxRequestTarget target = ((SaveModelEvent)event.getPayload()).getAjaxRequestTarget();
            LOG.debug(".onEvent AJAX - ObjectListPanel - SaveModelEvent: " + target.toString());
        }
    }

    private void removeSelectedItems(TreeGrid<DefaultTreeModel, DefaultMutableTreeNode, String> grid) {
        Collection selected = grid.getSelectedItems();
        for (IModel model : selected) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getObject();
            this.treeModel.removeNodeFromParent(node);
            PermObj permObj = (PermObj)node.getUserObject();
            LOG.debug(".removeSelectedItems user node: " + permObj.getObjName());
            List permObjs = (List)this.getDefaultModel().getObject();
            permObjs.remove(permObj);
        }
    }

    private DefaultTreeModel createTreeModel(List<PermObj> permObjs) {
        this.rootNode = new DefaultMutableTreeNode(null);
        DefaultTreeModel model = new DefaultTreeModel(this.rootNode);
        if (permObjs == null) {
            LOG.debug("no Permission Objects found");
        } else {
            LOG.debug(".createTreeModel Permission Objects found:" + permObjs.size());
            for (PermObj permObj : permObjs) {
                this.rootNode.add(new DefaultMutableTreeNode(permObj));
            }
        }
        return model;
    }

    private void addGrid() {
        ArrayList<PropertyColumn> columns = new ArrayList<PropertyColumn>();
        PropertyColumn objName = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Object Name")), "userObject.ObjName");
        objName.setInitialSize(300);
        columns.add(objName);
        PropertyColumn ou = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Perm Organization")), "userObject.Ou");
        ou.setInitialSize(200);
        columns.add(ou);
        PropertyColumn description = new PropertyColumn((IModel)Model.of((Serializable)((Object)"Description")), "userObject.Description");
        description.setInitialSize(500);
        columns.add(description);
        PropertyColumn type = new PropertyColumn((IModel)new Model((Serializable)((Object)"Type")), "userObject.Type");
        type.setInitialSize(200);
        columns.add(type);
        List permObjs = (List)this.getDefaultModel().getObject();
        this.treeModel = this.createTreeModel(permObjs);
        this.grid = new /* Unavailable Anonymous Inner Class!! */;
        this.grid.setAllowSelectMultiple(false);
        this.grid.setClickRowToSelect(true);
        this.grid.setClickRowToDeselect(false);
        this.grid.setSelectToEdit(false);
        this.grid.getTreeState().expandAll();
        this.listForm = new Form("objectlistform");
        this.listForm.add(new Component[]{this.grid});
        this.add(new Component[]{this.listForm});
        this.grid.setOutputMarkupId(true);
    }

    private void addOUSearchModal(Radio ouRb) {
        Component[] componentArray = new Component[1];
        ModalWindow ousModalWindow = new ModalWindow("ousearchmodal");
        componentArray[0] = ousModalWindow;
        this.listForm.add(componentArray);
        OUSearchModalPanel ouSearchModalPanel = new OUSearchModalPanel(ousModalWindow.getContentId(), ousModalWindow, false);
        ousModalWindow.setContent((Component)ouSearchModalPanel);
        ousModalWindow.setWindowClosedCallback((ModalWindow.WindowClosedCallback)new /* Unavailable Anonymous Inner Class!! */);
        ouRb.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        ousModalWindow.setTitle("Permission Object Organizational Unit Search Modal");
        ousModalWindow.setInitialWidth(450);
        ousModalWindow.setInitialHeight(450);
        ousModalWindow.setCookieName("permou-modal");
    }

    public void add(FortEntity entity) {
        if (this.getDefaultModelObject() != null) {
            List permObjs = (List)this.getDefaultModelObject();
            permObjs.add((PermObj)entity);
            this.treeModel.insertNodeInto(new DefaultMutableTreeNode(entity), this.rootNode, 0);
        }
    }

    public void prune() {
        this.removeSelectedItems(this.grid);
    }
}

