/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util.cache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import org.apache.directory.fortress.core.CfgException;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.util.ClassUtil;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheFactory;
import org.apache.directory.fortress.core.util.cache.EhCacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheMgr {
    private static final Logger LOG = LoggerFactory.getLogger((String)CacheMgr.class.getName());
    private static final String EHCACHE_CONFIG_FILE = "ehcache.config.file";
    private CacheManager mEhCacheImpl;
    private static volatile CacheMgr sINSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CacheMgr getInstance() {
        try {
            if (sINSTANCE != null) return sINSTANCE;
            Class<CacheMgr> clazz = CacheMgr.class;
            synchronized (CacheMgr.class) {
                if (sINSTANCE != null) return sINSTANCE;
                sINSTANCE = new CacheMgr();
                // ** MonitorExit[var0] (shouldn't be in output)
                return sINSTANCE;
            }
        }
        catch (Exception e) {
            String error = "CacheMgr.getInstance caught Exception=" + e.getMessage();
            LOG.error(error);
            throw new CfgRuntimeException(129, error, e);
        }
    }

    private void init() {
        String cacheConfig = Config.getInstance().getProperty(EHCACHE_CONFIG_FILE, "ehcache.xml");
        try {
            this.mEhCacheImpl = new CacheManager(ClassUtil.resourceAsStream(cacheConfig));
        }
        catch (CfgException ce) {
            LOG.error("CfgException caught  initializing cacher=" + ce.getMessage());
            throw new CfgRuntimeException(129, cacheConfig, ce);
        }
        catch (Exception e) {
            String error = "CacheMgr.init caught Exception=" + e.getMessage();
            LOG.error(error);
            throw new CfgRuntimeException(129, error, e);
        }
    }

    private CacheMgr() {
        this.init();
    }

    public Cache getCache(String cacheName) {
        Ehcache cache = this.mEhCacheImpl.getEhcache(cacheName);
        if (cache != null) {
            return new EhCacheImpl(cacheName, new BlockingCache(cache));
        }
        return CacheFactory.createInstance(cacheName, this.mEhCacheImpl);
    }

    public void clearAll() {
        this.mEhCacheImpl.clearAll();
    }
}

