/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.io.IOException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLdapConnectionFactory
implements LdapConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultLdapConnectionFactory.class);
    private LdapApiService apiService;
    private LdapConnectionConfig connectionConfig;
    private long timeout;

    public DefaultLdapConnectionFactory(LdapConnectionConfig config) {
        this.connectionConfig = config;
        this.timeout = config.getTimeout();
    }

    @Override
    public LdapConnection bindConnection(LdapConnection connection) throws LdapException {
        try {
            connection.bind(this.connectionConfig.getName(), this.connectionConfig.getCredentials());
        }
        catch (LdapException e) {
            block5: {
                LOG.error(I18n.err((I18n)I18n.ERR_04102_UNABLE_TO_BIND_CONNECTION, (Object[])new Object[]{e.getMessage()}));
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04158_UNABLE_TO_BIND, (Object[])new Object[]{e.getMessage()}));
                }
                try {
                    connection.close();
                }
                catch (IOException ioe) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04103_UNABLE_TO_CLOSE_FAILED_CONNECTION, (Object[])new Object[]{e.getMessage()}), (Throwable)ioe);
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug(I18n.msg((I18n)I18n.MSG_04159_UNABLE_TO_CLOSE_CONNECTION, (Object[])new Object[]{e.getMessage()}));
                }
            }
            throw e;
        }
        return connection;
    }

    @Override
    public LdapConnection configureConnection(LdapConnection connection) {
        connection.setTimeOut(this.timeout);
        connection.setBinaryAttributeDetector(this.connectionConfig.getBinaryAttributeDetector());
        return connection;
    }

    @Override
    public LdapApiService getLdapApiService() {
        return this.apiService;
    }

    @Override
    public LdapConnection newLdapConnection() throws LdapException {
        return this.bindConnection(this.newUnboundLdapConnection());
    }

    @Override
    public LdapConnection newUnboundLdapConnection() {
        if (this.apiService == null) {
            return this.configureConnection(new LdapNetworkConnection(this.connectionConfig));
        }
        return this.configureConnection(new LdapNetworkConnection(this.connectionConfig, this.apiService));
    }

    public void setLdapApiService(LdapApiService apiService) {
        this.apiService = apiService;
    }

    public void setTimeOut(long timeout) {
        this.timeout = timeout;
    }
}

