/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.actionstate;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.InputEvent;
import org.apache.flink.agents.api.OutputEvent;
import org.apache.flink.agents.runtime.actionstate.ActionState;
import org.apache.flink.agents.runtime.operator.ActionTask;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionStateKafkaDeserializer
implements Deserializer<ActionState> {
    private static final Logger LOG = LoggerFactory.getLogger(ActionStateKafkaDeserializer.class);
    private static final ObjectMapper OBJECT_MAPPER = ActionStateKafkaDeserializer.createObjectMapper();

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    @Override
    public ActionState deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readValue(data, ActionState.class);
        }
        catch (Exception e) {
            LOG.error("Failed to deserialize ActionState for topic: {}", (Object)topic, (Object)e);
            throw new RuntimeException("Failed to deserialize ActionState", e);
        }
    }

    @Override
    public void close() {
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(Event.class, EventTypeInfoMixin.class);
        mapper.addMixIn(InputEvent.class, EventTypeInfoMixin.class);
        mapper.addMixIn(OutputEvent.class, EventTypeInfoMixin.class);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ActionTask.class, new ActionTaskDeserializer());
        mapper.registerModule(module);
        return mapper;
    }

    public static class ActionTaskDeserializer
    extends JsonDeserializer<ActionTask> {
        @Override
        public ActionTask deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            p.skipChildren();
            return null;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    public static abstract class EventTypeInfoMixin {
    }
}

