/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class SinkRecord {
    private final BinaryRowData partition;
    private final int bucket;
    private final BinaryRowData primaryKey;
    private final RowData row;

    public SinkRecord(BinaryRowData partition, int bucket, BinaryRowData primaryKey, RowData row) {
        Preconditions.checkArgument(partition.getRowKind() == RowKind.INSERT);
        Preconditions.checkArgument(primaryKey.getRowKind() == RowKind.INSERT);
        this.partition = partition;
        this.bucket = bucket;
        this.primaryKey = primaryKey;
        this.row = row;
    }

    public BinaryRowData partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public BinaryRowData primaryKey() {
        return this.primaryKey;
    }

    public RowData row() {
        return this.row;
    }
}

