/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

class FailureResult {
    @Nullable
    private final Duration backoffTime;
    private final Throwable failureCause;

    private FailureResult(Throwable failureCause, @Nullable Duration backoffTime) {
        this.backoffTime = backoffTime;
        this.failureCause = failureCause;
    }

    boolean canRestart() {
        return this.backoffTime != null;
    }

    Duration getBackoffTime() {
        Preconditions.checkState(this.canRestart(), "Failure result must be restartable to return a backoff time.");
        return this.backoffTime;
    }

    Throwable getFailureCause() {
        return this.failureCause;
    }

    static FailureResult canRestart(Throwable failureCause, Duration backoffTime) {
        return new FailureResult(failureCause, backoffTime);
    }

    static FailureResult canNotRestart(Throwable failureCause) {
        return new FailureResult(failureCause, null);
    }
}

