/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filterrows;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.filterrows.FilterRowsData;
import org.apache.hop.pipeline.transforms.filterrows.FilterRowsMeta;

public class FilterRows
extends BaseTransform<FilterRowsMeta, FilterRowsData> {
    private static final Class<?> PKG = FilterRowsMeta.class;

    public FilterRows(TransformMeta transformMeta, FilterRowsMeta meta, FilterRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized boolean keepRow(IRowMeta rowMeta, Object[] row) throws HopException {
        try {
            return ((FilterRowsMeta)this.meta).getCondition().evaluate(rowMeta, row);
        }
        catch (Exception e) {
            String message = BaseMessages.getString(PKG, (String)"FilterRows.Exception.UnexpectedErrorFoundInEvaluationFuction", (String[])new String[0]);
            this.logError(message);
            this.logError(BaseMessages.getString(PKG, (String)"FilterRows.Log.ErrorOccurredForRow", (String[])new String[0]) + rowMeta.getString(row));
            this.logError(Const.getStackTracker((Throwable)e));
            throw new HopException(message, (Throwable)e);
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((FilterRowsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((FilterRowsMeta)this.meta).getFields(this.getInputRowMeta(), this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.checkNonExistingFields();
            if (((FilterRowsData)this.data).chosesTargetTransforms) {
                PipelineHopMeta hop;
                TransformMeta to;
                List targetStreams = ((FilterRowsMeta)this.meta).getTransformIOMeta().getTargetStreams();
                if (!Utils.isEmpty((CharSequence)((IStream)targetStreams.get(0)).getTransformName())) {
                    to = ((IStream)targetStreams.get(0)).getTransformMeta();
                    hop = this.getPipelineMeta().findPipelineHop(this.getTransformMeta(), to);
                    if (hop != null && hop.isEnabled()) {
                        ((FilterRowsData)this.data).trueRowSet = this.findOutputRowSet(this.getTransformName(), this.getCopy(), to.getName(), 0);
                        if (((FilterRowsData)this.data).trueRowSet == null) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"FilterRows.Log.TargetTransformInvalid", (String[])new String[]{((IStream)targetStreams.get(0)).getTransformName()}));
                        }
                    }
                } else {
                    ((FilterRowsData)this.data).trueRowSet = null;
                }
                if (!Utils.isEmpty((CharSequence)((IStream)targetStreams.get(1)).getTransformName())) {
                    to = ((IStream)targetStreams.get(1)).getTransformMeta();
                    hop = this.getPipelineMeta().findPipelineHop(this.getTransformMeta(), to);
                    if (hop != null && hop.isEnabled()) {
                        ((FilterRowsData)this.data).falseRowSet = this.findOutputRowSet(this.getTransformName(), this.getCopy(), to.getName(), 0);
                        if (((FilterRowsData)this.data).falseRowSet == null) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"FilterRows.Log.TargetTransformInvalid", (String[])new String[]{((IStream)targetStreams.get(1)).getTransformName()}));
                        }
                    }
                } else {
                    ((FilterRowsData)this.data).falseRowSet = null;
                }
            }
        }
        boolean keep = this.keepRow(this.getInputRowMeta(), r);
        if (!((FilterRowsData)this.data).chosesTargetTransforms) {
            if (keep) {
                this.putRow(((FilterRowsData)this.data).outputRowMeta, r);
            }
        } else if (keep) {
            if (((FilterRowsData)this.data).trueRowSet != null) {
                if (this.log.isRowLevel()) {
                    this.logRowlevel("Sending row to true  :" + ((FilterRowsData)this.data).trueTransformName + " : " + this.getInputRowMeta().getString(r));
                }
                this.putRowTo(((FilterRowsData)this.data).outputRowMeta, r, ((FilterRowsData)this.data).trueRowSet);
            }
        } else if (((FilterRowsData)this.data).falseRowSet != null) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to false :" + ((FilterRowsData)this.data).falseTransformName + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(((FilterRowsData)this.data).outputRowMeta, r, ((FilterRowsData)this.data).falseRowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FilterRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((FilterRowsMeta)this.meta).getCondition().clearFieldPositions();
            List targetStreams = ((FilterRowsMeta)this.meta).getTransformIOMeta().getTargetStreams();
            ((FilterRowsData)this.data).trueTransformName = ((IStream)targetStreams.get(0)).getTransformName();
            ((FilterRowsData)this.data).falseTransformName = ((IStream)targetStreams.get(1)).getTransformName();
            ((FilterRowsData)this.data).chosesTargetTransforms = ((IStream)targetStreams.get(0)).getTransformMeta() != null || ((IStream)targetStreams.get(1)).getTransformMeta() != null;
            return true;
        }
        return false;
    }

    protected void checkNonExistingFields() throws HopException {
        List<String> orphanFields = ((FilterRowsMeta)this.meta).getOrphanFields(((FilterRowsMeta)this.meta).getCondition(), this.getInputRowMeta());
        if (orphanFields != null && orphanFields.size() > 0) {
            Object fields = "";
            boolean first = true;
            for (String field : orphanFields) {
                if (!first) {
                    fields = (String)fields + ", ";
                }
                fields = (String)fields + "'" + field + "'";
                first = false;
            }
            String errorMsg = BaseMessages.getString(PKG, (String)"FilterRows.CheckResult.FieldsNotFoundFromPreviousTransform", (String[])new String[]{fields});
            throw new HopException(errorMsg);
        }
    }
}

