/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;

public class Props
implements Cloneable {
    private static final Class<?> PKG = Const.class;
    protected static final String NO = "N";
    protected static final String YES = "Y";
    private static final String STRING_USER_PREFERENCES = "User preferences";
    public static final String STRING_FONT_DEFAULT_NAME = "FontDefaultName";
    public static final String STRING_FONT_DEFAULT_SIZE = "FontDefaultSize";
    public static final String STRING_FONT_DEFAULT_STYLE = "FontDefaultStyle";
    public static final String STRING_FONT_FIXED_NAME = "FontFixedName";
    public static final String STRING_FONT_FIXED_SIZE = "FontFixedSize";
    public static final String STRING_FONT_FIXED_STYLE = "FontFixedStyle";
    public static final String STRING_FONT_GRAPH_NAME = "FontGraphName";
    public static final String STRING_FONT_GRAPH_SIZE = "FontGraphSize";
    public static final String STRING_FONT_GRAPH_STYLE = "FontGraphStyle";
    public static final String STRING_FONT_NOTE_NAME = "FontNoteName";
    public static final String STRING_FONT_NOTE_SIZE = "FontNoteSize";
    public static final String STRING_FONT_NOTE_STYLE = "FontNoteStyle";
    public static final String STRING_ZOOM_FACTOR = "ZoomFactor";
    public static final String STRING_ICON_SIZE = "IconSize";
    public static final String STRING_LINE_WIDTH = "LineWidth";
    public static final String STRING_MIDDLE_PCT = "MiddlePct";
    public static final String STRING_INDICATE_SLOW_PIPELINE_TRANSFORMS = "IndicateSlowPipelineTransforms";
    public static final String STRING_LAST_PREVIEW_TRANSFORM = "LastPreviewTransform";
    public static final String STRING_LAST_PREVIEW_SIZE = "LastPreviewSize";
    public static final String STRING_MAX_UNDO = "MaxUndo";
    public static final String STRING_AUTO_SAVE = "AutoSave";
    public static final String STRING_SAVE_CONF = "SaveConfirmation";
    public static final String STRING_AUTO_SPLIT = "AutoSplit";
    public static final String STRING_AUTO_COLLAPSE_CORE_TREE = "AutoCollapseCoreObjectsTree";
    public static final String STRING_USE_DB_CACHE = "UseDBCache";
    public static final String STRING_OPEN_LAST_FILE = "OpenLastFile";
    public static final String STRING_SHOW_CANVAS_GRID = "ShowCanvasGrid";
    public static final String STRING_SHOW_TABLE_VIEW_TOOLBAR = "ShowTableViewToolbar";
    public static final String STRING_SHOW_EXIT_WARNING = "ShowExitWarning";
    public static final String STRING_CUSTOM_PARAMETER = "CustomParameter";
    public static final String STRING_DEFAULT_PREVIEW_SIZE = "DefaultPreviewSize";
    public static final String TABLEOUTPUT_SORT_MAPPINGS = "TableOutputSortMappings";
    protected ILogChannel log = new LogChannel("User preferences");
    public static final int WIDGET_STYLE_DEFAULT = 0;
    public static final int WIDGET_STYLE_FIXED = 1;
    public static final int WIDGET_STYLE_TABLE = 2;
    public static final int WIDGET_STYLE_OSX_GROUP = 3;
    public static final int WIDGET_STYLE_TAB = 4;
    public static final int WIDGET_STYLE_TOOLBAR = 5;
    public static final int WIDGET_STYLE_PUSH_BUTTON = 6;
    public static final int WIDGET_STYLE_TREE = 7;

    public String toString() {
        return STRING_USER_PREFERENCES;
    }

    protected void setDefault() {
        if (!this.containsKey("WorkflowDialogStyle")) {
            this.setProperty("WorkflowDialogStyle", "RESIZE,MAX,MIN");
        }
    }

    protected void setProperty(String key, String value) {
        try {
            HopConfig.setGuiProperty(key, value);
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving hop config option key '" + key + "', value '" + value + "'", e);
        }
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        String value = HopConfig.getGuiProperty(propertyName);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public boolean containsKey(String key) {
        return HopConfig.getInstance().getConfigMap().containsKey(key);
    }

    public void setUseDBCache(boolean use) {
        this.setProperty(STRING_USE_DB_CACHE, use ? YES : NO);
    }

    public boolean useDBCache() {
        String use = this.getProperty(STRING_USE_DB_CACHE);
        return !NO.equalsIgnoreCase(use);
    }

    public boolean sortTableOutputMappings() {
        String sortMappings = this.getProperty(TABLEOUTPUT_SORT_MAPPINGS);
        return YES.equalsIgnoreCase(sortMappings);
    }

    public void setTableOutputSortMappings(boolean value) {
        this.setProperty(TABLEOUTPUT_SORT_MAPPINGS, value ? YES : NO);
    }

    public String getCustomParameter(String parameterName, String defaultValue) {
        return this.getProperty(STRING_CUSTOM_PARAMETER + parameterName, defaultValue);
    }

    public void setCustomParameter(String parameterName, String value) {
        this.setProperty(STRING_CUSTOM_PARAMETER + parameterName, value);
    }

    public void clearCustomParameters() throws HopException {
        Map<String, String> configMap = HopConfig.readGuiProperties();
        Iterator<Map.Entry<String, String>> iterator = configMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith(STRING_CUSTOM_PARAMETER)) continue;
            iterator.remove();
        }
        HopConfig.getInstance().saveToFile();
    }

    public void reset() {
        this.clear();
    }

    private void clear() {
        HopConfig.getInstance().getConfigMap().clear();
    }
}

