/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.io.kafka.DeserializerProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.kafka.common.serialization.Deserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class LocalDeserializerProvider<@UnknownKeyFor T>
implements DeserializerProvider<T> {
    private @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Deserializer<T>> deserializer;

    private LocalDeserializerProvider(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Deserializer<T>> deserializer) {
        Preconditions.checkArgument((deserializer != null ? 1 : 0) != 0, (Object)"You should provide a deserializer.");
        this.deserializer = deserializer;
    }

    static <T> @UnknownKeyFor @NonNull @Initialized LocalDeserializerProvider<T> of(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Deserializer<T>> deserializer) {
        return new LocalDeserializerProvider<T>(deserializer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Deserializer<T> getDeserializer(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> configs, @UnknownKeyFor @NonNull @Initialized boolean isKey) {
        try {
            Deserializer<T> deserializer = this.deserializer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            deserializer.configure(configs, isKey);
            return deserializer;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Could not instantiate deserializers", e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
        return this.getNullableCoder(coderRegistry);
    }

    public @UnknownKeyFor @NonNull @Initialized NullableCoder<T> getNullableCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
        for (Type type : this.deserializer.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Deserializer.class) continue;
            Type parameter = parameterizedType.getActualTypeArguments()[0];
            Class clazz = (Class)parameter;
            try {
                return NullableCoder.of((Coder)coderRegistry.getCoder(clazz));
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(String.format("Unable to automatically infer a Coder for the Kafka Deserializer %s: no coder registered for type %s", this.deserializer, clazz));
            }
        }
        throw new RuntimeException(String.format("Could not extract the Kafka Deserializer type from %s", this.deserializer));
    }
}

