/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaTransformReadConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public class BigQuerySchemaTransformReadProvider
extends TypedSchemaTransformProvider<BigQuerySchemaTransformReadConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String API = "bigquery";
    private static final @UnknownKeyFor @NonNull @Initialized String OUTPUT_TAG = "OUTPUT";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration> configurationClass() {
        return BigQuerySchemaTransformReadConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration configuration) {
        return new BigQueryReadSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return String.format("%s:read", API);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(OUTPUT_TAG);
    }

    static class PCollectionRowTupleTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple> {
        private final @UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration configuration;
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;

        PCollectionRowTupleTransform(@UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration configuration) {
            this.configuration = configuration;
        }

        @VisibleForTesting
        void setTestBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (!input.getAll().isEmpty()) {
                throw new IllegalArgumentException(String.format("%s %s input is expected to be empty", input.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName()));
            }
            BigQueryIO.TypedRead<TableRow> read = this.toTypedRead();
            if (this.testBigQueryServices != null) {
                read = read.withTestServices(this.testBigQueryServices).withoutValidation();
            }
            PCollection tableRowPCollection = (PCollection)input.getPipeline().apply(read);
            Schema schema = tableRowPCollection.getSchema();
            PCollection rowPCollection = (PCollection)tableRowPCollection.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)tableRow -> BigQueryUtils.toBeamRow(schema, tableRow)));
            return PCollectionRowTuple.of((String)BigQuerySchemaTransformReadProvider.OUTPUT_TAG, (PCollection)rowPCollection.setRowSchema(schema));
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> toTypedRead() {
            BigQueryIO.TypedRead<TableRow> read = BigQueryIO.readTableRowsWithSchema();
            if (!Strings.isNullOrEmpty((String)this.configuration.getQuery())) {
                read = read.fromQuery(this.configuration.getQuery());
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getTableSpec())) {
                read = read.from(this.configuration.getTableSpec());
            }
            if (this.configuration.getUseStandardSql() != null && this.configuration.getUseStandardSql().booleanValue()) {
                read = read.usingStandardSql();
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getQueryLocation())) {
                read = read.withQueryLocation(this.configuration.getQueryLocation());
            }
            return read;
        }
    }

    private static class BigQueryReadSchemaTransform
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration configuration;

        BigQueryReadSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQuerySchemaTransformReadConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return new PCollectionRowTupleTransform(this.configuration);
        }
    }
}

