/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Message;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.proto.PubSubMessage;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.TimeUnit;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PerServerPublisherCache;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PublisherAssembler;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PubsubLiteSink
extends DoFn<PubSubMessage, Void> {
    private final @UnknownKeyFor @NonNull @Initialized PublisherOptions options;
    @GuardedBy(value="this")
    private transient @UnknownKeyFor @NonNull @Initialized RunState runState;

    public PubsubLiteSink(@UnknownKeyFor @NonNull @Initialized PublisherOptions options) {
        this.options = options;
    }

    @DoFn.StartBundle
    public synchronized void startBundle() throws @UnknownKeyFor @NonNull @Initialized ApiException {
        this.runState = new RunState(this.options);
    }

    @DoFn.ProcessElement
    public synchronized void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized PubSubMessage message) throws @UnknownKeyFor @NonNull @Initialized CheckedApiException {
        this.runState.publish(message);
    }

    @DoFn.FinishBundle
    public synchronized void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.runState.waitForDone();
    }

    private static class RunState {
        private final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized ApiFuture<@UnknownKeyFor @NonNull @Initialized MessageMetadata>> futures = new ArrayDeque<ApiFuture<MessageMetadata>>();
        private final @UnknownKeyFor @NonNull @Initialized Publisher<@UnknownKeyFor @NonNull @Initialized MessageMetadata> publisher;

        RunState(@UnknownKeyFor @NonNull @Initialized PublisherOptions options) {
            this.publisher = PerServerPublisherCache.PUBLISHER_CACHE.get(options, () -> new PublisherAssembler(options).newPublisher());
        }

        void publish(@UnknownKeyFor @NonNull @Initialized PubSubMessage message) {
            this.futures.add((ApiFuture<MessageMetadata>)this.publisher.publish(Message.fromProto((PubSubMessage)message)));
        }

        void waitForDone() throws @UnknownKeyFor @NonNull @Initialized Exception {
            ApiFutures.allAsList(this.futures).get(1L, TimeUnit.MINUTES);
        }
    }
}

