/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PartitionPosition
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -9088898012221404492L;
    private final @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Timestamp> maybeTimestamp;
    private final @UnknownKeyFor @NonNull @Initialized PartitionMode mode;

    public static @UnknownKeyFor @NonNull @Initialized PartitionPosition updateState() {
        return new PartitionPosition(Optional.empty(), PartitionMode.UPDATE_STATE);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionPosition queryChangeStream(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        return new PartitionPosition(Optional.of(timestamp), PartitionMode.QUERY_CHANGE_STREAM);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionPosition waitForChildPartitions() {
        return new PartitionPosition(Optional.empty(), PartitionMode.WAIT_FOR_CHILD_PARTITIONS);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionPosition done() {
        return new PartitionPosition(Optional.empty(), PartitionMode.DONE);
    }

    public static @UnknownKeyFor @NonNull @Initialized PartitionPosition stop() {
        return new PartitionPosition(Optional.empty(), PartitionMode.STOP);
    }

    @VisibleForTesting
    public PartitionPosition(@UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Timestamp> maybeTimestamp, @UnknownKeyFor @NonNull @Initialized PartitionMode mode) {
        this.maybeTimestamp = maybeTimestamp;
        this.mode = mode;
    }

    public @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized Timestamp> getTimestamp() {
        return this.maybeTimestamp;
    }

    public @UnknownKeyFor @NonNull @Initialized PartitionMode getMode() {
        return this.mode;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionPosition)) {
            return false;
        }
        PartitionPosition that = (PartitionPosition)o;
        return Objects.equals(this.maybeTimestamp, that.maybeTimestamp) && this.mode == that.mode;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(new Object[]{this.maybeTimestamp, this.mode});
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "PartitionPosition{maybeTimestamp=" + this.maybeTimestamp + ", mode=" + (Object)((Object)this.mode) + '}';
    }
}

