/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterPane
extends Trigger.OnceTrigger {
    private final @UnknownKeyFor @NonNull @Initialized int countElems;

    private AfterPane(@UnknownKeyFor @NonNull @Initialized int countElems) {
        super(null);
        this.countElems = countElems;
    }

    public @UnknownKeyFor @NonNull @Initialized int getElementCount() {
        return this.countElems;
    }

    public static @UnknownKeyFor @NonNull @Initialized AfterPane elementCountAtLeast(@UnknownKeyFor @NonNull @Initialized int countElems) {
        return new AfterPane(countElems);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isCompatible(@UnknownKeyFor @NonNull @Initialized Trigger other) {
        return this.equals(other);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getWatermarkThatGuaranteesFiring(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
        return BoundedWindow.TIMESTAMP_MAX_VALUE;
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized Trigger.OnceTrigger getContinuationTrigger(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Trigger> continuationTriggers) {
        return AfterPane.elementCountAtLeast(1);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "AfterPane.elementCountAtLeast(" + this.countElems + ")";
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AfterPane)) {
            return false;
        }
        AfterPane that = (AfterPane)obj;
        return this.countElems == that.countElems;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.countElems);
    }
}

