/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.processors.query.calcite.rel.AbstractIgniteJoin;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class IgniteCorrelatedNestedLoopJoin
extends AbstractIgniteJoin {
    public IgniteCorrelatedNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    public IgniteCorrelatedNestedLoopJoin(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), (RelNode)input.getInputs().get(1), input.getExpression("condition"), (Set<CorrelationId>)ImmutableSet.copyOf(Commons.transform(input.getIntegerList("variablesSet"), CorrelationId::new)), (JoinRelType)input.getEnum("joinType", JoinRelType.class));
    }

    public Join copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new IgniteCorrelatedNestedLoopJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RelCollation leftCollation = TraitUtils.collation(left);
        RelCollation rightCollation = TraitUtils.collation(right);
        List newRightCollationFields = Commons.maxPrefix(rightCollation.getKeys(), this.joinInfo.leftKeys);
        if (F.isEmpty(newRightCollationFields)) {
            return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), inputTraits));
        }
        nodeTraits = this.variablesSet.size() == 1 ? nodeTraits.replace((RelTrait)leftCollation) : nodeTraits.replace((RelTrait)RelCollations.EMPTY);
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits, inputTraits));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RewindabilityTrait rewindability = TraitUtils.rewindability(left);
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), (Object)ImmutableList.of((Object)left, (Object)right.replace((RelTrait)RewindabilityTrait.REWINDABLE))));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        if (this.variablesSet.size() == 1) {
            Pair<RelTraitSet, List<RelTraitSet>> baseTraits = super.passThroughCollation(nodeTraits, inputTraits);
            return Pair.of((Object)((RelTraitSet)baseTraits.getKey()), (Object)ImmutableList.of((Object)((RelTraitSet)((List)baseTraits.getValue()).get(0)), (Object)((RelTraitSet)((List)baseTraits.getValue()).get(1))));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), (Object)ImmutableList.of((Object)left.replace((RelTrait)RelCollations.EMPTY), (Object)right));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RewindabilityTrait rewindability = TraitUtils.rewindability(nodeTraits);
        return Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), (Object)ImmutableList.of((Object)left.replace((RelTrait)rewindability), (Object)right.replace((RelTrait)RewindabilityTrait.REWINDABLE)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        List<Pair<RelTraitSet, List<RelTraitSet>>> traits = super.deriveDistribution(nodeTraits, inputTraits);
        RelTraitSet leftTraits = inputTraits.get(0);
        RelTraitSet rightTraits = inputTraits.get(1);
        IgniteDistribution leftDistr = TraitUtils.distribution(inputTraits.get(0));
        if (leftDistr.getType() == RelDistribution.Type.HASH_DISTRIBUTED && this.variablesSet.size() == 1) {
            traits = new ArrayList<Pair<RelTraitSet, List<RelTraitSet>>>(traits);
            traits.add((Pair<RelTraitSet, List<RelTraitSet>>)Pair.of((Object)nodeTraits.replace((RelTrait)leftDistr), (Object)ImmutableList.of((Object)leftTraits, (Object)rightTraits.replace((RelTrait)IgniteDistributions.correlated((CorrelationId)F.first((Iterable)this.variablesSet), leftDistr)))));
        }
        return traits;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double leftCnt = mq.getRowCount(this.getLeft());
        if (Double.isInfinite(leftCnt)) {
            return costFactory.makeInfiniteCost();
        }
        double rightCnt = mq.getRowCount(this.getRight());
        if (Double.isInfinite(rightCnt)) {
            return costFactory.makeInfiniteCost();
        }
        double rows = leftCnt * rightCnt;
        return costFactory.makeCost(rows, rows * 4.0, 0.0);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        CorrelationTrait nodeCorr = TraitUtils.correlation(nodeTraits);
        HashSet selfCorrIds = U.newHashSet((int)(this.variablesSet.size() + nodeCorr.correlationIds().size()));
        selfCorrIds.addAll(this.variablesSet);
        selfCorrIds.addAll(nodeCorr.correlationIds());
        return Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)inTraits.get(0).replace((RelTrait)nodeCorr), (Object)inTraits.get(1).replace((RelTrait)CorrelationTrait.correlations(selfCorrIds))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> rightCorrIds = TraitUtils.correlation(inTraits.get(1)).correlationIds();
        if (!rightCorrIds.containsAll((Collection<?>)this.variablesSet)) {
            return ImmutableList.of();
        }
        Set<CorrelationId> leftCorrIds = TraitUtils.correlation(inTraits.get(0)).correlationIds();
        HashSet corrIds = U.newHashSet((int)(rightCorrIds.size() + leftCorrIds.size()));
        corrIds.addAll(rightCorrIds);
        corrIds.addAll(leftCorrIds);
        corrIds.removeAll((Collection<?>)this.variablesSet);
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(corrIds)), inTraits));
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteCorrelatedNestedLoopJoin(cluster, this.getTraitSet(), (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.getCondition(), this.getVariablesSet(), this.getJoinType());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlationVariables", (Object)this.getVariablesSet());
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) / mq.getSelectivity((RelNode)this, this.getCondition());
    }
}

