/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.affinity;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.configuration.DeploymentMode;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;

class GridAffinityMessage
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private byte[] src;
    private IgniteUuid clsLdrId;
    private DeploymentMode depMode;
    private String srcClsName;
    private String userVer;
    @GridToStringInclude
    private Map<UUID, IgniteUuid> ldrParties;

    GridAffinityMessage(byte[] src, String srcClsName, IgniteUuid clsLdrId, DeploymentMode depMode, String userVer, Map<UUID, IgniteUuid> ldrParties) {
        this.src = src;
        this.srcClsName = srcClsName;
        this.depMode = depMode;
        this.clsLdrId = clsLdrId;
        this.userVer = userVer;
        this.ldrParties = ldrParties;
    }

    public GridAffinityMessage() {
    }

    public byte[] source() {
        return this.src;
    }

    public IgniteUuid classLoaderId() {
        return this.clsLdrId;
    }

    public DeploymentMode deploymentMode() {
        return this.depMode;
    }

    public String sourceClassName() {
        return this.srcClsName;
    }

    public String userVersion() {
        return this.userVer;
    }

    public Map<UUID, IgniteUuid> loaderParticipants() {
        return this.ldrParties != null ? Collections.unmodifiableMap(this.ldrParties) : null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeByteArray(out, this.src);
        out.writeInt(this.depMode.ordinal());
        U.writeIgniteUuid(out, this.clsLdrId);
        U.writeString(out, this.srcClsName);
        U.writeString(out, this.userVer);
        U.writeMap(out, this.ldrParties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.src = U.readByteArray(in);
        this.depMode = DeploymentMode.fromOrdinal(in.readInt());
        this.clsLdrId = U.readIgniteUuid(in);
        this.srcClsName = U.readString(in);
        this.userVer = U.readString(in);
        this.ldrParties = U.readMap(in);
    }

    public String toString() {
        return S.toString(GridAffinityMessage.class, this);
    }
}

