/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.CharSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.Util;

class ConvTable {
    private final FST<CharsRef> fst;
    private final FixedBitSet firstCharHashes;
    private final int mod;

    ConvTable(TreeMap<String, String> mappings) {
        this.mod = Math.max(256, Integer.highestOneBit(mappings.size()) << 1);
        this.firstCharHashes = new FixedBitSet(this.mod);
        try {
            CharSequenceOutputs outputs = CharSequenceOutputs.getSingleton();
            Builder fstCompiler = new Builder(FST.INPUT_TYPE.BYTE2, (Outputs)outputs);
            IntsRefBuilder scratchInts = new IntsRefBuilder();
            for (Map.Entry<String, String> entry : mappings.entrySet()) {
                String key = entry.getKey();
                assert (key.length() > 0);
                this.firstCharHashes.set(key.charAt(0) % this.mod);
                Util.toUTF16((CharSequence)key, (IntsRefBuilder)scratchInts);
                fstCompiler.add(scratchInts.get(), (Object)new CharsRef(entry.getValue()));
            }
            this.fst = fstCompiler.finish();
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    void applyMappings(StringBuilder sb) {
        FST.BytesReader bytesReader = null;
        FST.Arc firstArc = null;
        FST.Arc arc = null;
        for (int i = 0; i < sb.length(); ++i) {
            if (!this.mightReplaceChar(sb.charAt(i))) continue;
            if (firstArc == null) {
                firstArc = this.fst.getFirstArc(new FST.Arc());
                bytesReader = this.fst.getBytesReader();
                arc = new FST.Arc();
            }
            arc.copyFrom(firstArc);
            CharsRef output = (CharsRef)this.fst.outputs.getNoOutput();
            int longestMatch = -1;
            CharsRef longestOutput = null;
            for (int j = i; j < sb.length(); ++j) {
                char ch = sb.charAt(j);
                try {
                    if (this.fst.findTargetArc((int)ch, arc, arc, bytesReader) == null) break;
                    output = (CharsRef)this.fst.outputs.add((Object)output, arc.output());
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
                if (!arc.isFinal()) continue;
                longestOutput = (CharsRef)this.fst.outputs.add((Object)output, arc.nextFinalOutput());
                longestMatch = j;
            }
            if (longestMatch < 0) continue;
            sb.delete(i, longestMatch + 1);
            sb.insert(i, (CharSequence)longestOutput);
            i += longestOutput.length - 1;
        }
    }

    boolean mightReplaceChar(char c) {
        return this.firstCharHashes.get(c % this.mod);
    }
}

