/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.cache.processor.MutableEntry;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheProxyImpl;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SingleNode;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.ModifyTuple;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ModifyNode<Row>
extends AbstractNode<Row>
implements SingleNode<Row>,
Downstream<Row> {
    protected final CacheTableDescriptor desc;
    private final TableModify.Operation op;
    private final List<String> cols;
    private List<ModifyTuple> tuples = new ArrayList<ModifyTuple>(MODIFY_BATCH_SIZE);
    private long updatedRows;
    private int waiting;
    private int requested;
    private boolean inLoop;
    private State state = State.UPDATING;

    public ModifyNode(ExecutionContext<Row> ctx, RelDataType rowType, CacheTableDescriptor desc, TableModify.Operation op, List<String> cols) {
        super(ctx, rowType);
        this.desc = desc;
        this.op = op;
        this.cols = cols;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.tryEnd();
        }
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.state == State.UPDATING);
        this.checkState();
        --this.waiting;
        switch (this.op) {
            case DELETE: 
            case UPDATE: 
            case INSERT: 
            case MERGE: {
                this.tuples.add(this.desc.toTuple(this.context(), row, this.op, this.cols));
                this.flushTuples(false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.op.name());
            }
        }
        if (this.waiting == 0) {
            this.waiting = MODIFY_BATCH_SIZE;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        this.waiting = -1;
        this.state = State.UPDATED;
        this.tryEnd();
    }

    @Override
    protected void rewindInternal() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    private void tryEnd() throws Exception {
        assert (this.downstream() != null);
        if (this.state == State.UPDATING && this.waiting == 0) {
            this.waiting = MODIFY_BATCH_SIZE;
            this.source().request(this.waiting);
        }
        if (this.state == State.UPDATED && this.requested > 0) {
            this.flushTuples(true);
            this.state = State.END;
            this.inLoop = true;
            try {
                --this.requested;
                this.downstream().push(this.context().rowHandler().factory(Long.TYPE).create(this.updatedRows));
            }
            finally {
                this.inLoop = false;
            }
        }
        if (this.state == State.END && this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private void flushTuples(boolean force) throws IgniteCheckedException {
        if (F.isEmpty(this.tuples) || !force && this.tuples.size() < MODIFY_BATCH_SIZE) {
            return;
        }
        List<ModifyTuple> tuples = this.tuples;
        this.tuples = new ArrayList<ModifyTuple>(MODIFY_BATCH_SIZE);
        GridCacheContext cctx = this.desc.cacheContext();
        GridCacheProxyImpl cache = cctx.cache().keepBinary();
        GridNearTxLocal tx = (GridNearTxLocal)Commons.queryTransaction(this.context(), cctx.shared());
        if (tx == null) {
            this.invokeOutsideTransaction(tuples, (GridCacheProxyImpl<Object, Object>)cache);
        } else {
            this.invokeInsideTransaction(tuples, (GridCacheProxyImpl<Object, Object>)cache, tx);
        }
    }

    private void invokeOutsideTransaction(List<ModifyTuple> tuples, GridCacheProxyImpl<Object, Object> cache) throws IgniteCheckedException {
        Map<Object, EntryProcessor<Object, Object, Long>> map = this.invokeMap(tuples);
        Map res = cache.invokeAll(map, new Object[0]);
        long updated = res.values().stream().mapToLong(EntryProcessorResult::get).sum();
        if ((this.op == TableModify.Operation.INSERT || this.op == TableModify.Operation.MERGE) && updated != (long)res.size()) {
            List<Object> conflictKeys = res.entrySet().stream().filter(e -> (Long)((EntryProcessorResult)e.getValue()).get() == 0L).map(Map.Entry::getKey).collect(Collectors.toList());
            throw this.conflictKeysException(conflictKeys);
        }
        this.updatedRows += updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInsideTransaction(List<ModifyTuple> tuples, GridCacheProxyImpl<Object, Object> cache, GridNearTxLocal userTx) throws IgniteCheckedException {
        userTx.resume();
        try {
            this.invokeOutsideTransaction(tuples, cache);
        }
        finally {
            userTx.suspend();
        }
    }

    private IgniteSQLException conflictKeysException(List<Object> conflictKeys) {
        if (this.op == TableModify.Operation.INSERT) {
            return new IgniteSQLException("Failed to INSERT some keys because they are already in cache. [cache=" + this.desc.cacheContext().name() + ", keys=" + conflictKeys + "]", 4001);
        }
        return new IgniteSQLException("Failed to MERGE some keys due to keys conflict or concurrent updates. [cache=" + this.desc.cacheContext().name() + ", keys=" + conflictKeys + "]", 4002);
    }

    private Map<Object, EntryProcessor<Object, Object, Long>> invokeMap(List<ModifyTuple> tuples) {
        LinkedHashMap procMap = U.newLinkedHashMap((int)tuples.size());
        block5: for (ModifyTuple entry : tuples) {
            assert (entry.getOp() == this.op || this.op == TableModify.Operation.MERGE) : entry.getOp();
            switch (entry.getOp()) {
                case INSERT: {
                    if (procMap.put(entry.getKey(), new InsertOperation(entry.getValue())) == null) continue block5;
                    throw this.conflictKeysException(Collections.singletonList(entry.getKey()));
                }
                case UPDATE: {
                    procMap.put(entry.getKey(), new UpdateOperation(entry.getValue()));
                    continue block5;
                }
                case DELETE: {
                    assert (this.op == TableModify.Operation.DELETE);
                    procMap.put(entry.getKey(), new DeleteOperation());
                    continue block5;
                }
            }
            throw new AssertionError((Object)("Unexpected tuple operation: " + entry.getOp()));
        }
        return procMap;
    }

    private static class DeleteOperation<K, V>
    implements EntryProcessor<K, V, Long> {
        private DeleteOperation() {
        }

        public Long process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
            if (entry.exists()) {
                entry.remove();
                return 1L;
            }
            return 0L;
        }
    }

    private static class UpdateOperation<K, V>
    implements EntryProcessor<K, V, Long> {
        private final V val;

        private UpdateOperation(V val) {
            this.val = val;
        }

        public Long process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
            if (entry.exists()) {
                entry.setValue(this.val);
                return 1L;
            }
            return 0L;
        }
    }

    private static class InsertOperation<K, V>
    implements EntryProcessor<K, V, Long> {
        private final V val;

        private InsertOperation(V val) {
            this.val = val;
        }

        public Long process(MutableEntry<K, V> entry, Object ... arguments) throws EntryProcessorException {
            if (!entry.exists()) {
                entry.setValue(this.val);
                return 1L;
            }
            return 0L;
        }
    }

    private static enum State {
        UPDATING,
        UPDATED,
        END;

    }
}

