/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.util.typedef.F;

public class UnionAllNode<Row>
extends AbstractNode<Row>
implements Downstream<Row> {
    private int curSrc;
    private int waiting;

    public UnionAllNode(ExecutionContext<Row> ctx, RelDataType rowType) {
        super(ctx, rowType);
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        assert (this.sources() != null);
        assert (idx >= 0 && idx < this.sources().size());
        return this;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()));
        assert (rowsCnt > 0 && this.waiting == 0);
        this.checkState();
        this.waiting = rowsCnt;
        this.source().request(this.waiting);
    }

    @Override
    public void push(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        this.downstream().push(row);
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        if (++this.curSrc < this.sources().size()) {
            this.source().request(this.waiting);
        } else {
            this.waiting = -1;
            this.downstream().end();
        }
    }

    @Override
    protected void rewindInternal() {
        this.curSrc = 0;
        this.waiting = 0;
    }

    private Node<Row> source() {
        return this.sources().get(this.curSrc);
    }
}

